% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LikGradHess.general.R
\name{LikGradHess.general}
\alias{LikGradHess.general}
\title{Likelihood, gradient and Hessian for univariate transition intensity based models}
\usage{
LikGradHess.general(
  params,
  data = NULL,
  full.X = NULL,
  MM,
  pen.matr.S.lambda,
  aggregated.provided = FALSE,
  do.gradient = TRUE,
  do.hessian = TRUE,
  pmethod = "analytic",
  death,
  Qmatr.diagnostics.list = NULL,
  verbose = FALSE,
  parallel = FALSE,
  no_cores = 2
)
}
\arguments{
\item{params}{Parameters vector.}

\item{data}{Dataset in proper format.}

\item{full.X}{Full design matrix.}

\item{MM}{List of necessary setup quantities.}

\item{pen.matr.S.lambda}{Penalty matrix multiplied by smoothing parameter lambda.}

\item{aggregated.provided}{Whether aggregated form was provided (may become obsolete in the future if we see original dataset as special case of aggregated where \code{nrep = 1}).}

\item{do.gradient}{Whether or not to compute the gradient.}

\item{do.hessian}{Whether or not to compute the Hessian.}

\item{pmethod}{Method to be used for computation of transition probability matrix. See help of \code{msm()} for further details.}

\item{death}{Whether the last state is an absorbing state.}

\item{Qmatr.diagnostics.list}{List of maximum absolute values of the Q matrices computed during model fitting.}

\item{verbose}{Whether to print out the progress being made in computing the likelihood, gradient and Hessian.}

\item{parallel}{Whether or not to use parallel computing (only for Windows users for now).}

\item{no_cores}{Number of cores used if parallel computing chosen. The default is 2. If \code{NULL}, all available cores are used.}
}
\value{
Penalized likelihood, gradient and Hessian associated with model at given parameters, for use by trust region algorithm.
}
\description{
Likelihood, gradient and Hessian for univariate transition intensity based models
}
