% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted_flocker.R
\name{fitted_flocker}
\alias{fitted_flocker}
\title{Posterior predictive distributions for modeled probabilities}
\usage{
fitted_flocker(
  flocker_fit,
  components = c("occ", "det", "col", "ex", "auto", "Omega"),
  new_data = NULL,
  unit_level = FALSE,
  summarise = FALSE,
  CI = c(0.05, 0.95),
  draw_ids = NULL,
  response = TRUE,
  re_formula = NULL,
  allow_new_levels = FALSE,
  sample_new_levels = "uncertainty"
)
}
\arguments{
\item{flocker_fit}{A flocker_fit object.}

\item{components}{a character vector specifying one or more of "occ",
"det", "col", "ex", "auto", and "Omega" for which to obtain fitted values.}

\item{new_data}{Optional new data at which to evaluate occupancy predictions. 
New data can be passed as a flocker_data object produced by 
\code{make_flocker_data} or as a dataframe with one row per desired
prediction. If `NULL` (the default) expected values are generated for the 
original data as formatted by make_flocker_data.}

\item{unit_level}{Logical; defaults to FALSE. Relevant only when `new_data`
is not a dataframe (i.e. it is `NULL` or a flocker_data object), and useful
only for multiseason models with missing seasons. If FALSE, returns in the 
shape of the observation matrix/array with NAs for missing visits. If
TRUE, returns in the shape of the first visit, and returns values for all
units that are not part of a trailing block of never-visited units,
including never-visited units that are part of series with subsequent 
visits.}

\item{summarise}{if TRUE, return the expected value and upper and lower bound 
of the credible interval, otherwise return posterior draws.}

\item{CI}{A vector of length 2 specifying the upper and lower bounds of the 
credible interval.}

\item{draw_ids}{Vector of indices of the posterior draws to be 
used. If `NULL` (the default) all draws are used in their native order.}

\item{response}{Should results be returned on the response or logit scale? 
Defaults to `TRUE`, i.e. response scale. However, the autologistic
parameter is not interpretable as a probability and is always returned
on the logit scale regardless of the value of `response`}

\item{re_formula}{formula containing group-level effects to be considered in 
the prediction. If `NULL` (default), include all group-level effects; if 
NA, include no group-level effects.}

\item{allow_new_levels}{allow new levels for random effect terms in `new_data`?
Will error if set to `FALSE` and new levels are provided in `new_data`.}

\item{sample_new_levels}{If new_data is provided and contains random effect
levels not present in the original data, how should predictions be
handled? Passed directly to `brms::prepare_predictions`, which see.}
}
\value{
A list of sets of expected values (one per component). If `new_data` 
    is a dataframe, each element contains one row per row of `new_data`.
    Otherwise, returns in the shape of the observation matrix/array used 
    to format the flocker_data (but see `unit_level` parameter for further
    details).
}
\description{
Get expected values of the posterior predictive distribution for the modeled
probabilities (occupancy, detection, colonization, extinction, autologistic).
}
\details{
The probabilities returned are conditional probabilities (e.g. detection 
conditional on occupancy, colonization conditional on previous 
non-occupancy, etc). These probabilities are not conditioned on the 
observed histories (e.g. the occupancy probability is not fixed to one 
at sites with a detection; it is estimated only based on the covariates).
}
\examples{
\donttest{
fitted_flocker(
  example_flocker_model_single, 
  summarise = TRUE
)
}
}
