% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/product_gev.R
\name{qBM}
\alias{qBM}
\title{Block maxima distribution}
\usage{
qBM(p, b, param)
}
\arguments{
\item{p}{vector of probabilities.}

\item{b}{block length (in general \code{b} \eqn{\ge 2}).}

\item{param}{three-dimensional vector with location (mu), scale (sigma)
and shape (xi) parameter.}
}
\value{
Quantile of a block maxima distribution.
}
\description{
Calculates quantiles of a block maxima distribution.
}
\details{
Formular of a block maxima distribution function:
\deqn{F_j(x)=F_j^{(b)}(x)=\left[2\cdot T_{1/\xi}\left(\left\{1+\xi\frac{x-\mu_j}{\sigma_j}\right\}\cdot T_{1/\xi}^{-1}\left(1-\frac{1}{2b}\right)\right)-1\right]^b,}{F_j(x)=F_j^(b)(x)=[2 T_{1/xi}({1+xi (x-mu_j)/(sigma_j)} T_{1/xi}^{-1}(1-1/(2b)))-1]^b,}
where \eqn{T_{\nu}}{T_nu} denote the t-distribution function with \eqn{\nu}{nu} degrees of freedom.
}
\examples{
qBM(p=c(0.75, 0.99), b=12, param=c(2,1,0.2))
}

