% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmi_functions.R
\name{determine_npc}
\alias{determine_npc}
\title{Determine Number of FPCs Automatically}
\usage{
determine_npc(Y_mat, argvals, target_pve = 0.95, max_npc = 6L)
}
\arguments{
\item{Y_mat}{A numeric matrix (N x M) where N is subjects, M is time points.}

\item{argvals}{A numeric vector of length M listing the observation points.}

\item{target_pve}{The target cumulative PVE to reach (default: 0.95).}

\item{max_npc}{The maximum number of components to retain (default: 6L).}
}
\value{
A list containing:
\item{npc}{The selected number of components.}
\item{pooled_fpca}{The \code{fpca.sc} object from the \code{refund} package.}
\item{scree}{A tibble with PVE and cumulative PVE for each component.}
}
\description{
Determines the number of functional principal components (FPCs)
required to meet a target Proportion of Variance Explained (PVE).
}
\examples{
\donttest{
  sim <- simulate_fmi_data(N_A = 20, N_B = 20, T_points = 30)
  npc_info <- determine_npc(sim$Y_mat, sim$argvals)
  print(npc_info$npc)
}
}
