% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mphasegain.R
\name{mphase.gain}
\alias{mphase.gain}
\title{mphase.gain}
\usage{
mphase.gain(esttable.obj, pref.vartype = "g_variance", exclude.synth = TRUE)
}
\arguments{
\item{esttable.obj}{an object of class \code{esttable} created by the \code{\link{estTable}} function}

\item{pref.vartype}{preferred type of multiphase variance that should be compared to the \code{onephase} variance,
if more then one variance type has been calculated in the multiphase estimation object(s) stored in
\code{esttable}. Valid input values are \code{"g_variance"} (default) and \code{"ext_variance"}.}

\item{exclude.synth}{\code{logical}. If set to \code{TRUE} (default), synthetic estimations are not considered in the validation.}
}
\value{
\code{mphase.gain} returns a \code{data.frame} containing the following components:

 \itemize{
    \item \code{area:} in case of small area estimation: the name of the small area
    \item \code{var_onephase:} standard error of the \code{\link{onephase}} estimation
    \item \code{var_multiphase:} smallest variance among the (set of) multiphase estimations stored in \code{esttable.obj}
    \item \code{estimator:} multiphase estimator with the smallest variance
    \item \code{method:} estimation Method of the multiphase estimator with the smallest variance
    \item \code{gain:} the \emph{gain} is the reduction (if value is positive) or possibly also the increase (if value is negative)
                       in variance when applying the multiphase as alternative to the onephase estimation
    \item \code{rel.eff:} the \emph{relative efficiency} defined as the ratio between the onephase variance and the multiphase variance
    %\item \code{perc.of.onephase:} ratio between the smallest multiphase standard error and the onephase standard error
 }
}
\description{
\code{mphase.gain} takes as input an object created by the \code{\link{estTable}} function
and returns a validation of which multiphase method and estimator performed best in comparison
to the onephase estimation (baseline) in terms of estimation precision.
}
\note{
The \emph{gain} can be interpreted as: "The multiphase estimation procedure leads to a \code{gain} \% reduction in variance compared to the
onephase procedure".

The \emph{relative efficiency} can be interpreted as: "Using the onephase estimation procedure, the terrestrial sample size would have to be \code{rel.eff} times larger in order to achieve the same precision (in terms of variance) as the mutiphase estimation procedure".


% @example examples/example_mphasegain.R
}
