#  (c) Copyright 2023 Palantir Technologies Inc. All rights reserved.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

# The version of the OpenAPI document: 1.0.0
# Generated by: https://openapi-generator.tech

#' @include config.R
NULL

#' @keywords internal
ApiClient  <- R6::R6Class( # nolint: cyclopcomp_linter
  "ApiClient",
  public = list(
    # base path of all requests
    base_path = NULL,
    # user agent in the HTTP request
    user_agent = sprintf("foundry-r-sdk/%s", toString(utils::packageVersion("foundry"))),
    # default headers in the HTTP request
    default_headers = NULL,
    # Access token
    access_token = NULL,
    # Time Out (seconds)
    timeout = NULL,
    # Vector of status codes to retry. By default, match java remoting
    # https://github.com/palantir/conjure-java-runtime/tree/3.12.0#quality-of-service-retry-failover-throttling
    retry_status_codes = c(308, 429, 503),
    # Maximum number of retry attempts for the retry status codes
    max_retry_attempts = 4,
    # constructor
    initialize = function(base_path, access_token) {
      self$base_path <- base_path
      self$access_token <- access_token
      self$default_headers["Authorization"] <- sprintf("Bearer %s", access_token)
      # By default, match CURL timeout
      self$timeout <- as.numeric(get_config("requests.timeout", 150))
    },

    stop_for_status = function(resp) {
      status <- httr::status_code(resp)
      if (status < 300) {
        return(invisible(resp))
      }

      message <- tryCatch({
        reason <- jsonlite::toJSON(httr::content(resp, as = "parsed"), pretty = TRUE, auto_unbox = TRUE)
        sprintf("%s (HTTP %d).", reason, status)
      },
      error = function(e) {
        reason <- httr::http_status(status)$reason
        sprintf("%s (HTTP %d).", reason, status)
      })
      stop(message)
    },

    call_api = function(url, method, query_params = NULL, header_params = NULL, body = NULL, ...) {
      if (missing(query_params)) {
        query_params <- list()
      }
      if (missing(header_params)) {
        header_params <- c()
      }

      resp <- self$execute(url, method, query_params, header_params, body, ...)
      status_code <- httr::status_code(resp)

      if (is.null(self$max_retry_attempts)) {
        self$max_retry_attempts <- 3
      }

      if (!is.null(self$retry_status_codes)) {

        for (i in 1 : self$max_retry_attempts) {
          if (status_code %in% self$retry_status_codes) {
            Sys.sleep((2 ^ i) + stats::runif(n = 1, min = 0, max = 1))
            resp <- self$execute(url, method, query_params, header_params, body, ...)
            status_code <- httr::status_code(resp)
          } else {
            break
          }
        }
      }

      resp
    },

    execute = function(url, method, query_params, header_params, body, ...) {
      headers <- httr::add_headers(c(header_params, self$default_headers))

      http_timeout <- NULL
      if (!is.null(self$timeout)) {
        http_timeout <- httr::timeout(self$timeout)
      }

      if (method == "GET") {
        httr::GET(url, query = query_params, headers, http_timeout, httr::user_agent(self$`user_agent`), ...)
      } else if (method == "POST") {
        httr::POST(url, query = query_params, headers, body = body, http_timeout,
                   httr::user_agent(self$`user_agent`), ...)
      } else if (method == "PUT") {
        httr::PUT(url, query = query_params, headers, body = body, http_timeout,
                  httr::user_agent(self$`user_agent`), ...)
      } else if (method == "PATCH") {
        httr::PATCH(url, query = query_params, headers, body = body, http_timeout,
                    httr::user_agent(self$`user_agent`), ...)
      } else if (method == "HEAD") {
        httr::HEAD(url, query = query_params, headers, http_timeout, httr::user_agent(self$`user_agent`), ...)
      } else if (method == "DELETE") {
        httr::DELETE(url, query = query_params, headers, http_timeout, httr::user_agent(self$`user_agent`), ...)
      } else {
        err_msg <- "Http method must be `GET`, `HEAD`, `OPTIONS`, `POST`, `PATCH`, `PUT` or `DELETE`."
        stop(err_msg)
      }
    }
  )
)
