% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freewall.R
\name{freewall-shiny}
\alias{freewall-shiny}
\alias{freewallOutput}
\alias{renderFreewall}
\title{Shiny bindings for 'freewall'}
\usage{
freewallOutput(outputId, width = "100\%", height = "auto")

renderFreewall(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{a valid CSS dimension (like \code{"100\%"},
\code{"400px"}, \code{"auto"}) or a number, which will be coerced to a
string and have \code{"px"} appended}

\item{expr}{an expression that generates a \code{\link{freewall}}}

\item{env}{the environment in which to evaluate \code{expr}}

\item{quoted}{logical, whether \code{expr} is a quoted expression
(with \code{quote()}); this is useful if you want to save an expression
in a variable}
}
\value{
\code{freewallOutput} returns an output element that can be included
  in a Shiny UI definition, and \code{renderFreewall} returns a
  \code{shiny.render.function} object that can be included in a Shiny server
  definition.
}
\description{
Output and render functions for using \code{freewall} within
  Shiny applications and interactive Rmd documents.
}
\examples{
if(require(shiny) && interactive()) {
library(shiny)
library(freewall)

ui <- fluidPage(
  freewallOutput("fw")
)

server <- function(input, output, session) {
  output$fw <- renderFreewall({
    freewall(alphabet(), widths = 200, cellW = 200, cellH = "auto")
  })
}

shinyApp(ui, server)
}

}
