% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_known_ratio.R
\name{knownqpcr_unpaired}
\alias{knownqpcr_unpaired}
\title{Estimate auxiliary parameters when the sample pairs are incomplete.}
\usage{
knownqpcr_unpaired(
  Digest,
  Gene,
  trueY,
  Cq,
  A = rep(1, length(Cq)),
  XInit = c(meanDNA = -10, targetScale = 0, baseChange = 0, sdMeasure = 1, zeroAmount =
    -5, EPCR = 0),
  method = "BFGS",
  pvalue = 0.05,
  trace = 0,
  report = 10,
  verbose = FALSE
)
}
\arguments{
\item{Digest}{Numeric vector having the same length as \code{Gene}, \code{trueY}, and \code{Cq}. \code{NA} is not allowed. In the RED-\eqn{\Delta\Delta}Cq method, it specify the sample is intact (= 0) or digested with endonuclease (= 1). In other \eqn{\Delta\Delta}Cq-based analyses, there will be no control sample and all observations must be marked \code{Digest = 1}.}

\item{Gene}{Numeric vector that specify each Cq measure (element of \code{Cq}) was taken with housekeeping (= 0) or target (= 1) locus. \code{NA} is not allowed.}

\item{trueY}{A numeric vector. \code{trueY[i]} signifies the exact frequency of the mutant allele in the \emph{i}th sample. The values must be between 0 and 1, and \code{NA} is not allowed. To improve the estimation accuracy, it is better to include the settings y == 0 (pure S solution) and y == 1 (pure R) in your dataset.}

\item{Cq}{Measured Cq values. This argument is a numeric vector and can contain \code{NA}s. The vector length must be the same as \code{Digest}, \code{Gene}, and \code{trueY} (i.e., missing values must be filled with \code{NA}).}

\item{A}{Optionally, you can specify relative DNA content between the samples, as a numeric vector having the same length as \code{Cq}. If present, \code{A} must not include missing values. It is the counterpart of the \code{N} argument in \code{\link{freqpcr}()}, whereas an element of \code{A} is not restricted to integer. Because the concentration as a whole is also adjusted with the parameter \code{meanDNA} (see Value section), \code{A} is used exclusively to reflect the relative contents between the sample solutions. Otherwise, \code{A} should be left unspecified (the default is 1 for all replicates).}

\item{XInit}{Optionally, the named vector specifies the initial parameter values to be optimized. Defined in the natural log scale; e.g. \code{zeroAmount = -5} corresponds to the residue rate \code{exp(-5)} = 0.007. Keeping the default is highly recommended.}

\item{method}{A string specifying the optimization algorithm used in \code{\link[stats]{optim}()}. The default is \code{BFGS}, which is plausible in most situation.}

\item{pvalue}{The two-sided confidence interval is calculated at the last iteration at given significance level. Default is 0.05, which returns the 95\% Wald's CI (2.5 to 97.5 percentile) based on the Hessian matrix.}

\item{trace}{Non-negative integer. If positive, \code{\link[stats]{optim}()} outputs trace information. The default is 0 (no information).}

\item{report}{The frequency of reports if \code{trace} is positive. Defaults to every 10 iterations.}

\item{verbose}{Send messages to stdout? Default is FALSE.}
}
\value{
A table containing the estimated parameter values. The format is same as \code{\link{knownqpcr}()}.
}
\description{
A variant of \code{\link{knownqpcr}()} that accepts the Cq values concatenated into a vector (the argument \code{Cq}) accompanied with the experimental conditions (the arguments \code{Digest} and \code{Gene}). Their exact allele mixing ratios are known as \code{trueY}.
}
\examples{
# A dummy Cq dataset: four mixing ratios with four replicates.
# K:2, scaleDNA:1e-11, targetScale:1.5, baseChange:0.3, zeroAmount:1e-3,
# sdMeasure:0.3, and EPCR:0.95. Assuming a RED-DeltaDeltaCq analyses.
trueY <- c(rep(0.1, 4), rep(0.25, 4), rep(0.5, 4), rep(1, 4))
housek0 <- c( 19.39, 19.78, 19.28, 19.58,  18.95, 19.91, 19.66, 19.96,
              20.05, 19.86, 19.55, 19.61,  19.86, 19.27, 19.59, 20.21 )
target0 <- c( 19.16, 19.08, 19.28, 19.03,  19.17, 19.67, 18.68, 19.52,
              18.92, 18.79, 18.8, 19.28,   19.57, 19.21, 19.05, 19.15 )
housek1 <- c( 21.61, 21.78, 21.25, 21.07,  22.04, 21.45, 20.72, 21.6,
              21.51, 21.27, 21.08, 21.7,   21.44, 21.46, 21.5, 21.8 )
target1 <- c( 24.3, 24.22, 24.13, 24.13,   22.74, 23.14, 23.02, 23.14,
              21.65, 22.62, 22.28, 21.65,  20.83, 20.82, 20.76, 21.3 )

# Incomplete observation dataset, prepared as the "long" format.
# If the undegested (Digest == 0) samples were only analyzed when trueY == 1.
d.long.all <- data.frame(
    trueY=rep(trueY, 4), Digest=c(rep(0, 16 + 16), rep(1, 16 + 16)),
    Gene=c(rep(0, 16), rep(1, 16), rep(0, 16), rep(1, 16)),
    A=rep(1, 16*4), Cq=c(housek0, target0, housek1, target1)  )
d.long <- d.long.all[d.long.all$Digest == 1 | d.long.all$trueY == 1, ]
print(d.long)

knownqpcr_unpaired( Digest=d.long$Digest, Gene=d.long$Gene,
                    trueY=d.long$trueY, Cq=d.long$Cq, A=d.long$A )

# In general DeltaDeltaCq analyses, the experimental design will not include
# dedicated control samples (Digest == 0).
d.long <- d.long.all[d.long.all$Digest == 1, ]
knownqpcr_unpaired( Digest=d.long$Digest, Gene=d.long$Gene,
                    trueY=d.long$trueY, Cq=d.long$Cq, A=d.long$A )
}
\seealso{
Other estimation procedures: 
\code{\link{freqpcr}()},
\code{\link{knownqpcr}()},
\code{\link{sim_dummy}()}
}
\concept{estimation procedures}
