% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo.R
\name{geo_shapefiles_read}
\alias{geo_shapefiles_read}
\title{Read and transform shapefiles from a ZIP archive}
\usage{
geo_shapefiles_read(zip_path, crs = 2154)
}
\arguments{
\item{zip_path}{\code{character}. Path to the ZIP archive to read.}

\item{crs}{\code{numeric} or \code{sf::st_crs} object. Source CRS to assume
if missing in the shapefiles. Default is 2154 (Lambert-93).}
}
\value{
A list of \code{sf} objects transform to CRS:2154.
}
\description{
Extracts shapefiles from a ZIP archive, reads them into \code{sf} objects,
and transform each to CRS:2154 (Lambert-93 projection for France),
unless already in the target CRS.
}
\keyword{internal}
