% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{quiet}
\alias{quiet}
\title{Execute an expression completely silently}
\usage{
quiet(expr)
}
\arguments{
\item{expr}{An R expression or function call to execute silently.}
}
\value{
The result of evaluating \code{expr}.
}
\description{
This utility executes any R expression or function call and returns its value,
while suppressing all printed output (cat, print), warnings, and messages.
}
\details{
\itemize{
\item Useful to suppress noisy outputs from functions during package or script execution.
\item Evaluation occurs in the parent environment to access local variables.
\item Works cross-platform by redirecting \code{capture.output} to \code{nul} on Windows or \verb{/dev/null} on other OS.
}
}
\keyword{internal}
