% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsi_module.R
\name{visitation}
\alias{visitation}
\title{Visitation: An example of FSI model}
\usage{
visitation()
}
\value{
An FSI model without fuzzy rules set.
}
\description{
\code{visitation()} provides an example, without rules, of a fuzzy spatial inference (FSI) model.
}
\details{
The \code{visitation()} function provides a hypothetical FSI model that estimates the visiting experience based on prices and overall ratings of accommodations as well as sanitary conditions of restaurants.
The output of such a model infers a value between 0 and 100 that indicates how attractive it is to visit a specific location.
For this, the experience can be classified as \emph{awful}, \emph{average}, and \emph{great}.

The linguistic variables and their linguistic values of this FSI model are listed below:
\itemize{
\item \emph{accommodation price} with \emph{cut-rate}, \emph{affordable}, and \emph{expensive} as linguistic values.
\item \emph{accommodation review} with \emph{bad}, \emph{good}, and \emph{excellent} as linguistic values.
\item \emph{food safety} with \emph{low}, \emph{medium}, and \emph{high} as linguistic values, which represent levels of sanitary conditions.
}

Note that this is just a small running example, containing a small set of points to represent the locations of accommodations and restaurants.

The usage of FSI models is subdivided into a \emph{preparation phase} and an \emph{evaluation phase}.
The preparation phase is responsible for instantiating a new FSI model with the elements of the data source component of FIFUS.
For this, the \code{fsr} package provides the following functions: \code{fsi_create()}, \code{fsi_add_fsa()}, and \code{fsi_add_cs()}.
These functions are employed by \code{visitation()} so that users can add their own fuzzy set rules (by using \code{fsi_add_rules()}) and perform the evaluation phase (by using the functions \code{fsi_eval()} and/or \code{fsi_qw_eval()}).

In this sense, \code{visitation()} performs the following internal actions to return an FSI model:
\enumerate{
\item specify the linguistic variables and their corresponding linguistic values, which are in turn represented by membership functions. These items are specified according to the context of the running example.
\item define small point datasets that represent each linguistic variable. Such datasets are \code{tibble} objects.
\item build spatial plateau objects by using \code{spa_creator()} on the datasets. As a result, we get spatial plateau objects that represent each linguistic value.
\item create an FSI model with \code{fsi_create()} function.
\item add fuzzy spatial antecedents with \code{fsi_add_fsa()}. Recall that the antecedents are spatial plateau objects previously built.
\item define the linguistic variable and its linguistic values with membership functions for the consequent.
\item add the consequent to the FSI model by using \code{fsi_add_cs()}.
}
}
\examples{

fsi <- visitation()

}
\references{
This function is based on the running example introduced in:
\itemize{
\item \href{https://dl.acm.org/doi/10.1145/3474717.3484255}{Carniel, A. C.; Galdino, F.; Philippsen, J. S.; Schneider, M. Handling Fuzzy Spatial Data in R Using the fsr Package. In Proceedings of the 29th International Conference on Advances in Geographic Information Systems (AM SIGSPATIAL 2021), pp. 526-535, 2021.}
}

Underlying concepts and formal definitions of FIFUS are discussed in:
\itemize{
\item \href{https://ieeexplore.ieee.org/document/8015707}{Carniel, A. C.; Schneider, M. Fuzzy inference on fuzzy spatial objects (FIFUS) for spatial decision support systems. In Proceedings of the 2017 IEEE International Conference on Fuzzy Systems (FUZZ-IEEE 2017), pp. 1-6, 2017.}
}
}
