% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMI_DNA.R
\name{MMI_DNA}
\alias{MMI_DNA}
\title{Multivariate Mutual Information_DNA (MMI_DNA)}
\usage{
MMI_DNA(seqs, label = c())
}
\arguments{
\item{seqs}{is a FASTA file containing nucleotide sequences. The sequences start
with '>'. Also, seqs could be a string vector. Each element of the vector is a nucleotide sequence.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
It is a feature matrix. The number of columns is 30 and the number of rows is equal to the number of sequences.
}
\description{
MMI computes mutual information based on 2-mers T2 = { AA, AC, AG, AT, CC, CG, CT, GG, GT, TT}
and 3-mers T3 = {AAA, AAC, AAG, AAT, ACC, ACG, ACT, AGG, AGT, ATT, CCC, CCG, CCT, CGG, CGT, CTT, GGG, GGT, GTT and TTT}
for more information please check the reference part.
}
\examples{

fileLNC<-system.file("extdata/Athaliana_LNCRNA.fa",package="ftrCOOL")
mat<-MMI_DNA(seqs=fileLNC)
}
\references{
Zhen Chen, Pei Zhao, Chen Li, Fuyi Li, Dongxu Xiang, Yong-Zi Chen, Tatsuya Akutsu, Roger J Daly, Geoffrey I Webb, Quanzhi Zhao, Lukasz Kurgan, Jiangning Song. iLearnPlus: a comprehensive and automated machine-learning platform for nucleic acid and protein sequence analysis, prediction and visualization, Nucleic Acids Research (2021).
}
