% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fwalk.R
\name{fwalk}
\alias{fwalk}
\title{Walk over a vector or list with side effects}
\usage{
fwalk(.x, .f, ncores = NULL, pb = FALSE, ...)
}
\arguments{
\item{.x}{A list or atomic vector of elements to iterate over.}

\item{.f}{A function to apply to each element of `.x`. Should be called primarily for side effects.}

\item{ncores}{Integer. Number of cores to use for parallel processing. Default is `NULL` (sequential).}

\item{pb}{Logical. Whether to show a progress bar. Default is `FALSE`.}

\item{...}{Additional arguments passed to `.f`.}
}
\value{
Invisibly returns `.x`, like `purrr::walk()`.
}
\description{
Applies a function `.f` to each element of `.x`, typically for its side effects (e.g., printing, writing files).
This function is the side-effect-friendly equivalent of `fmap()`. Supports parallel execution and progress bar display.
}
\examples{
# Print each element
fwalk(1:3, print)

# Simulate writing files in parallel
\donttest{
fwalk(1:3, function(i) {
  cat(paste("Processing item", i, "\n"))
  Sys.sleep(0.5)
}, ncores = 2, pb = TRUE)
}

}
