% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layouts.R
\name{fruchterman_layout}
\alias{fruchterman_layout}
\title{Generate G6 Fruchterman layout configuration}
\usage{
fruchterman_layout(height = NULL, width = NULL, gravity = 10, speed = 5, ...)
}
\arguments{
\item{height}{Numeric. Layout height. Defaults to container height.}

\item{width}{Numeric. Layout width. Defaults to container width.}

\item{gravity}{Numeric. Central force attracting nodes to the center.
Larger values make the layout more compact. Defaults to 10.}

\item{speed}{Numeric. Node movement speed per iteration. Higher values may cause oscillation. Defaults to 5.}

\item{...}{Additional parameters to pass to the layout.
See \url{https://g6.antv.antgroup.com/en/manual/layout/fruchterman-layout}.}
}
\value{
A list containing the configuration for G6 fruchterman layout.
}
\description{
This function creates a configuration list for G6 Fruchterman layout
with all available options as parameters.
}
\examples{
if (interactive()) {
  g6(lesmis$nodes, lesmis$edges) |>
   g6_layout(fruchterman_layout(
     gravity = 5,
     speed = 5
   )) |>
   g6_behaviors(
     "zoom-canvas",
     drag_element()
   )
}

}
