% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_setops.R
\name{set-operations}
\alias{set-operations}
\alias{maximal_sets}
\alias{minimal_sets}
\alias{remove_redundant}
\alias{is_inset}
\alias{filter_maximal_vectors}
\alias{get_subset}
\alias{get_superset}
\alias{is_subsetof}
\alias{is.subsetof}
\alias{subsetof}
\title{Suite of set operations}
\usage{
maximal_sets(setlist, index = FALSE)

minimal_sets(setlist, index = FALSE)

remove_redundant(setlist, maximal = TRUE, index = FALSE)

is_inset(x, setlist, index = FALSE)

filter_maximal_vectors(setlist, index = FALSE)

get_subset(x, setlist, all = FALSE)

get_superset(x, setlist, all = FALSE)

is_subsetof(set, set2)

is.subsetof(x, set)

subsetof(x, set)
}
\arguments{
\item{setlist}{List of vectors (representing a set of subsets)}

\item{index}{Logical; should indices (in setlist) be returned or a
set of subsets.}

\item{maximal}{Logical; see section 'Details' for a description.}

\item{x, set, set2}{Vector representing a set.}

\item{all}{Logical; see section 'Details' for a description.}
}
\description{
Set operations for gRbase and related packages.
}
\details{
'setlist' is a list of vectors representing a set of subsets;
i.e. V1,...VQ where Vk is a subset of some base set V.

'all' If true, \code{get_superset} will return index of all
vectors containing the element; otherwise only the first index is
returned.

\code{is_inset}: Checks if the set
x is in one of the Vk's.

\code{remove_redundant}: Returns those Vk which are not contained
in other subsets; i.e. gives the maximal sets. If maximal is FALSE
then returns the minimal sets; i.e. Vk is returned if Vk is
contained in one of the other sets Vl and there are no set Vn
contained in Vk.

Notice that the comparisons are made by turning the elements into
characters and then comparing these. Hence 1 is identical to "1".
}
\examples{

set <- list(c(1, 2), c(1, 2, 3), c(2, 3, 6), c(2, 4), c(5, 6), 5)            
                                                            
el1 <- c(2, 1)                                               
el2 <- c(2, 3)                                               
el3 <- c(4, 3)                                               
el4 <- c(2, 1, 3)                                             
                                                            
maximal_sets(set)                                           
minimal_sets(set)                                           
                                                            
remove_redundant(set)                                       
remove_redundant(set, maximal=FALSE)                        
                                                            
is_inset(el1, set)                                          
is_inset(el2, set)                                          
is_inset(el3, set)                                          
                                                            
get_subset(el1, set)
get_subset(el1, set)                                        
get_subset(el2, set)                                        
get_subset(el3, set)                                        

get_superset(el1, set)                                      
get_superset(el1, set, all=TRUE)                                      
get_superset(el2, set)                                      
get_superset(el3, set)

is_subsetof(el1, el1)                                       
is_subsetof(el1, el2)                                       
is_subsetof(el1, el4)

}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
