% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral_coords.R
\name{spectral_coords}
\alias{spectral_coords}
\title{Spectral Coordinates for Graph Drawing}
\usage{
spectral_coords(adj_mat)
}
\arguments{
\item{adj_mat}{A symmetric adjacency matrix or sparse matrix representing an undirected graph.}
}
\value{
A matrix where each row represents the spectral coordinates of a node in the graph.
}
\description{
Calculates the spectral coordinates of a graph using the two smallest non-zero eigenvalues of the graph Laplacian.
}
\details{
The \code{spectral_coords} function implements a 2-dimensional spectral graph drawing method based on the eigenvectors of the graph Laplacian associated with its two smallest non-zero eigenvalues. Given a graph with adjacency matrix \code{adj_mat}, the graph Laplacian \code{L} is computed, which is a matrix representation that encodes the graph's topology. The Laplacian's eigenvalues and eigenvectors are calculated, and the eigenvectors corresponding to the second and third non-zero smallest eigenvalues are used to determine the coordinates of the graph's vertices in the plane.
}
\examples{
\dontrun{
matrixname <- "bcspwr02"
groupname <- "HB"
download_graph(matrixname,groupname)
xy <- spectral_coords(bcspwr02$sA)
bcspwr02$xy <- xy
plot_graph(bcspwr02)
}
}
\references{
Chung, F. R. K. (1997). Spectral Graph Theory. American Mathematical Soc.

Hall, K. M. (1970). An r-dimensional quadratic placement algorithm. Management science, 17(3), 219-229.
}
\seealso{
\code{\link{plot_graph}}, \code{\link{plot_signal}}
}
