% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speciation.R
\name{get_divergence_factor}
\alias{get_divergence_factor}
\title{Allows the user to define the rate at which geographic clusters accumulate differentiation
with each other.}
\usage{
get_divergence_factor(species, cluster_indices, landscape, config)
}
\arguments{
\item{species}{the species of the current time step}

\item{cluster_indices}{an index vector indicating the cluster every occupied site is part of}

\item{landscape}{the landscape of the current time step}

\item{config}{the config of the simulation}
}
\value{
a single value or a matrix of divergences between all clusters occurring in clusters_indices
}
\description{
Allows the user to define the rate at which geographic clusters accumulate differentiation
with each other.
}
\details{
This function determines the increase in divergence between separated clusters of a species. This function
should return either (i) a single value if there is an homogeneous divergence, or (ii) a matrix indicating the divergence that
should be accumulated between specific pairwise geographic clusters.

The function can either return a single value or a full cluster by cluster matrix. If only one value is returned it will be used 
to increment divergence between any given distinct cluster pairs. If a matrix is returned it has to be in the dimension of
cluster x cluster, in which case the divergence values will be increased according to the cluster membership of any cell pairs.

For every time step, the divergence between geographic clusters can increase by a defined number. The divergence values can be 
scaled optionally using the species or landscape information. For instance, the divergence between clusters could be higher under
warmer temperature, or difference in ecological traits could promote faster divergence between clusters.

Oppositely, for every time-step, if cluster are merged their divergence is reduced by one (1).
}
