% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/momentVote.R
\name{momentVote}
\alias{momentVote}
\title{Function compares Pearson Stats and Sharpe Ratio for a matrix of stock returns}
\usage{
momentVote(mtx, weight = c(1, -1, 0.5, -0.5, 1))
}
\arguments{
\item{mtx}{{n by p matrix of data, For example, n stock returns
for p stocks. The mtx columns
should have some names (ticker symbols)}}

\item{weight}{{vector of reliability weights. default: mean=1, sd=-1,
skew=0.5,kurt=-0.5,sharpe=1}}
}
\value{
a matrix with same number of columns as in the input matrix x and
eleven rows. Top five rows have moment quantities, next five are their ranks
the eleventh row has weighted sum of ranks with the input weights (see default)
and the 12-th row has choice numbers (choice=1 is best)
}
\description{
The first step computes mean, std.dev, skewness, kurtosis (kurt),and
the Sharpe Ratio (mean/sd) representing risk-adjusted return where sd measures
the risk. The input x must be a matrix having p columns (col.names recommended).
and n rows as in the data.  If data are missing for some columns, insert NA's.
Thus x has p column of data matrix ready for comparison and ranking. 
For example, x has a matrix of stock returns.
The output matrix produced by this function has p columns for each data
column (i.e. for each stock being compared). The output matrix has
twelve rows. Top five rows have the magnitudes of 
mean, sd, skew, kurt, Sharpe ratios.  Output matrix 
rows 6 to 10 have respective ranks of moment stats. 
The output 11-th row  reports a weighted sum
of ranks with following weights mean=1,sd=-1,skew=0.5,kurt=-0.5,Sharpe Ratio=1.
User has the option to change the weights. They measure relative importance.
}
\details{
Since skewness and kurtosis are measured relatively less
reliably (have greater sampling variation due to higher powers) their weight
is 0.5. Our ranking gives the smallest number 1 to the most desirable outcome.  
The 11-th line of the
output matrix has weighted sum of ranks and we suggest higher portfolio weight
be given to the column having smallest value (in the bottom line).
The 12-th row of output matrix has `choice,' where input weights give
the number 1 is for the top choice column of data and all other choice numbers.
The (p+1)-th column of the output matrix has the chosen weights.  The argument
weight to the `momentVote' function allows one to change these weights.
}
\examples{
x1=c(1,4,7,2,6)
x2=c(3,4,8,4,7)
momentVote(cbind(x1,x2))

}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
