% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rss.z.test.R
\name{rss.z.test}
\alias{rss.z.test}
\title{RSS z-test for one-sample and two-sample problems}
\usage{
rss.z.test(
  data1,
  data2 = NULL,
  alpha = 0.05,
  alternative = "two.sided",
  mu0 = 0
)
}
\arguments{
\item{data1}{A numeric data frame of ranked set samples with columns \code{rank} for ranks and \code{y} for data values.}

\item{data2}{An optional numeric data frame of ranked set samples with columns \code{rank} for ranks and \code{y} for data values (for two-sample problem).}

\item{alpha}{A numeric value specifying the confidence level for the interval.}

\item{alternative}{A character string specifying the alternative hypothesis. Must be one of "two.sided" (default), "greater", or "less".}

\item{mu0}{A numeric value indicating the hypothesized value of the mean (for a one-sample problem) or the difference in means (for a two-sample problem).}
}
\value{
\item{RSS_mean}{The RSS mean estimate for a one-sample problem or a vector of RSS mean estimates for each group in a two-sample problem.}
\item{CI}{The confidence interval for the population mean for a one-sample problem or for the mean difference in a two-sample problem.}
\item{z}{The z-statistic for the test.}
\item{p.value}{The p-value for the test.}
}
\description{
The rss.z.test function performs one- and two-sample z-tests on ranked set sample data using normal approximation, with options for specifying the confidence level, alternative hypothesis, and hypothesized mean or mean difference.
}
\details{
This function performs a z-test on ranked set sample data for both one-sample and two-sample mean comparison problems, using normal approximation. For a one-sample test, only \code{data1} is needed, provided as a data frame with columns \code{rank} and \code{y}. For a two-sample test, both \code{data1} and \code{data2} must be supplied, each as data frames with \code{rank} and \code{y} columns. The function computes the test statistic, confidence interval, and p-value based on the provided RSS data and specified parameters.
}
\examples{
## Balanced RSS with a set size 3 and equal sample sizes of 6 for each stratum,
## using imperfect ranking from a normal distribution with a mean of 0.
rss.data1=rss.simulation(H=3,nsamp=c(6,6,6),dist="normal", rho=0.8,delta=0)

## one-sample z-test
rss.z.test(data1=rss.data1, data2=NULL, alpha=0.05,
alternative="two.sided", mu0=0)

## Unbalanced RSS with a set size 3 and different sample sizes of 6, 10, and 8 for each stratum,
## using imperfect ranking from a normal distribution with a mean of 0.
rss.data2<-rss.simulation(H=3,nsamp=c(6,8,10),dist="normal", rho=0.8,delta=0)

## two-sample z-test
rss.z.test(data1=rss.data1, data2=rss.data2, alpha=0.05,
alternative="two.sided", mu0=0)

}
\references{
Chen, Z., Bai Z., Sinha B. K. (2003). Ranked Set Sampling: Theory and Application. New York: Springer.

S. Ahn, J. Lim, and X. Wang. (2014) The student’s t approximation to distributions of pivotal statistics from ranked set samples. Journal of the Korean Statistical Society, 43, 643–652.

S. Ahn, X. Wang, C. Moon, and J. Lim. (2024) New scheme of empirical likelihood method for ranked set sampling: Applications to two one sample problems. International Statistical Review.
}
\seealso{
\code{\link{rss.simulation}}: used for simulating Ranked Set Samples (RSS), which can serve as input.

\code{\link{rss.sampling}}: used for sampling Ranked Set Samples (RSS) from a population data set, providing input data.
}
