% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossover.R
\name{crossover}
\alias{crossover}
\title{Crossover of  selected parents from the fitting population}
\usage{
crossover(selected_parents, offspring_size)
}
\arguments{
\item{selected_parents}{The list of selected individuals from the population.}

\item{offspring_size}{The number of offspring that the selected population should have.}
}
\value{
The output expected should be a list of offspring for the next generation.
}
\description{
This function performs crossover between the selected individuals that fit the best
based on the predefined condition(aim/objective). \cr
e.g.: To optimize the function \eqn{f(x) = x^2 - 4x + 4}
to find the value of \eqn{x} that minimizes the function.
\eqn{x}: represents a possible value the an individual from the population can have.
}
\examples{
population <- c(1, 3, 0)

# Evaluate fitness
fitness <- evaluate_fitness(population)
print("Evaluation:")
print(fitness)

# Selection
selected_parents <- selection(population, fitness, num_parents = 2)
print("Selection:")
print(selected_parents)

# Crossover
offspring <- crossover(selected_parents, offspring_size = 2)
print("Crossover:")
print(offspring)

}
\author{
Dany Mukesha
}
