% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_data_synapse.R
\name{.get_and_query_file_url}
\alias{.get_and_query_file_url}
\title{Get URL for a given 'Synapse' file and download to local machine}
\usage{
.get_and_query_file_url(
  version_num,
  file_handle_id,
  synapse_id,
  df,
  name,
  download_folder,
  download_location,
  token,
  file_endpoint_url
)
}
\arguments{
\item{version_num}{cohort name and version}

\item{file_handle_id}{'Synapse' file handle ID}

\item{synapse_id}{'Synapse' ID}

\item{df}{package designated name of file}

\item{name}{file name from 'Synapse'}

\item{download_folder}{location to download data}

\item{token}{Synapse token}

\item{file_endpoint_url}{'Synapse' endpoint for file info}
}
\value{
list of 'Synapse' data frames
}
\description{
Get URL for a given 'Synapse' file and download to local machine
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

file <- data.frame(
  version_num = "NSCLC_v2.1",
  file_handle_id = c("79432768"),
  synapse_id = c("syn25985884"),
  df = c("pt_char"),
  name = c("patient_level_dataset.csv"),
  download_folder = file.path(tempdir(), "NSCLC_v2.1")
)

purrr::pmap(file, .get_and_query_file_url)
\dontshow{\}) # examplesIf}
}
\keyword{internal}
