% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synapse_authentication.R
\name{set_synapse_credentials}
\alias{set_synapse_credentials}
\title{Connect to 'Synapse' API}
\usage{
set_synapse_credentials(username = NULL, password = NULL, pat = NULL)
}
\arguments{
\item{username}{'Synapse' username. If NULL, package will search
environmental variables for `SYNAPSE_USERNAME`.}

\item{password}{'Synapse' password. If NULL, package will search
environmental variables for `SYNAPSE_PASSWORD`.}

\item{pat}{'Synapse' Personal Access Token. If NULL, package will search
environmental variables for `SYNAPSE_PAT`.}
}
\value{
A success message if you credentials are valid for 'Synapse'
platform; otherwise an error
}
\description{
This function sets 'Synapse' credentials for the user's current session.
}
\details{
To access data, users must have a valid 'Synapse' account with permission to
access the data set and they must have accepted any necessary 'Terms of Use'.
Users must authenticate themselves in their current R session.
(See README 'Data Access and Authentication' at https://genie-bpc.github.io/genieBPC/ for details).
To set your 'Synapse' credentials during each session, call:
 `set_synapse_credentials(username = "your_username", password = "your_password")`.

In addition to passing your 'Synapse' username and password, you may choose to set
your 'Synapse' Personal Access Token (PAT) by calling:
 `set_synapse_credentials(pat = "your_pat")`.

If your credentials are stored as environmental variables, you do not need to call
`set_synapse_credentials()` explicitly each session. To store authentication
information in your environmental variables, add the following to your
.Renviron file, then restart your R session
(tip: you can use `usethis::edit_r_environ()` to easily open/edit this file):

\itemize{
   \item `SYNAPSE_USERNAME = <your-username>`
   \item `SYNAPSE_PASSWORD = <your-password>`
   \item `SYNAPSE_PAT = <your-pat>`
   }

Alternatively, you can pass your username and password or your PAT to each individual
data pull function if preferred, although it is recommended that you manage
your passwords outside of your scripts for security purposes.
}
\examples{
\dontrun{
set_synapse_credentials(
  username = "your-username",
  password = "your-password"
)
set_synapse_credentials(
  pat = "your-personal-access-token"
)
}

}
\author{
Karissa Whiting
}
