% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.precision.R
\name{plot.precision}
\alias{plot.precision}
\title{Plot Shrinkage vs. Variance for Ridge Precision}
\usage{
\method{plot}{precision}(
  x,
  xvar = "norm.beta",
  yvar = c("det", "trace", "max.eig"),
  labels = c("lambda", "df"),
  label.cex = 1.25,
  label.prefix,
  criteria = NULL,
  pch = 16,
  cex = 1.5,
  col,
  main = NULL,
  xlab,
  ylab,
  ...
)
}
\arguments{
\item{x}{A data frame of class \code{"precision"} resulting from \code{\link{precision}} called
on a \code{"ridge"} object. Named \code{x} only to conform with the \code{\link{plot}} generic.}

\item{xvar}{The character name of the column to be used for the horizontal axis. Typically, this is the normalized sum 
of squares of the coefficients (\code{"norm.beta"}) used as a measure of shrinkage / bias.}

\item{yvar}{The character name of the column to be used for the vertical axis. One of 
\code{c("det", "trace", "max.eig")}. See \code{\link{precision}} for definitions of these measures.}

\item{labels}{The character name of the column to be used for point labels. One of \code{c("lambda", "df")}.}

\item{label.cex}{Character size for point labels.}

\item{label.prefix}{Character or expression prefix for the point labels.}

\item{criteria}{The vector of optimal shrinkage criteria from the \code{\link{ridge}} call to be added
as points in the plot.}

\item{pch}{Plotting character for points}

\item{cex}{Character size for points}

\item{col}{Point colors}

\item{main}{Plot title}

\item{xlab}{Label for horizontal axis}

\item{ylab}{Label for vertical axis}

\item{...}{Other arguments passed to \code{\link{plot}}.}
}
\value{
Returns nothing. Used for the side effect of plotting.
}
\description{
This function uses the results of \code{\link{precision}} to
plot a measure of shrinkage of the coefficients in ridge regression against a selected measure
of their estimated sampling variance, so as to provide a direct visualization of the tradeoff
between bias and precision.
}
\examples{
lambda <- c(0, 0.001, 0.005, 0.01, 0.02, 0.04, 0.08)
lridge <- ridge(Employed ~ GNP + Unemployed + Armed.Forces + 
                  Population + Year + GNP.deflator, 
                data=longley, lambda=lambda)

criteria <- lridge$criteria |> print()

pridge <- precision(lridge) |> print()

plot(pridge)
# also show optimal criteria
plot(pridge, criteria = criteria)

# use degrees of freedom as point labels 
plot(pridge, labels = "df")
plot(pridge, labels = "df", label.prefix="df:")
# show the trace measure
plot(pridge, yvar="trace")
}
\seealso{
\code{\link{ridge}} for details on ridge regression as implemented here.
  \code{\link{precision}} for definitions of the measures
}
\author{
Michael Friendly
}
