\name{compound}
\alias{dcompound}
\alias{pcompound}
\alias{qcompound}
\alias{rcompound}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
The Exponentiated and Exponentiated2 distributions
}
\description{
Density, distribution function, quantile function and random generation for the compound distributions.
}
\usage{
dcompound(x, dist = "exp", comp1 = as.null(), comp2 = as.null(), gamma = 1, beta = 1, 
	theta1 = 1, theta2 = 1, log = FALSE)
pcompound(q, dist = "exp", comp1 = as.null(), comp2 = as.null(), gamma = 1, beta = 1, 
	theta1 = 1, theta2 = 1, lower.tail = TRUE, log.p = FALSE)
qcompound(p, dist = "exp", comp1 = as.null(), comp2 = as.null(), gamma = 1, beta = 1, 
	theta1 = 1, theta2 = 1, lower.tail = TRUE, log.p = FALSE)
rcompound(n, dist = "exp", comp1 = as.null(), comp2 = as.null(), gamma = 1, beta = 1, 
	theta1 = 1, theta2 = 1)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x, q}{
vector of quantiles.
}
  \item{p}{
vector of probabilities.
}
  \item{n}{
number of observations. If length(n) > 1, the length is taken to be the number required.
}
\item{dist}{
baseline distribution. Avaliable options: exp (exponential), gamma, lnorm (log-normal),
	paretoII, bisa (Birnbaum-Saunders), lomax, beta, kumar (Kumaraswamy), norm (normal), logis (logistic),
	cauchy, gumbel. See details for parameterizations of these distributions.
}
\item{comp1, comp2}{
compounding distributions. Avaliable options: EXP (Exponentiated), EXP2 (Exponentiated of the second kind),
	MO (Marshall-Olkin), MO2 (Marshall-Olkin of the second kind), SB (Shaw and Buckley).
}
\item{gamma, beta}{
parameters for the baseline distribution.
}
\item{theta1, theta2}{
shape parameter for the comp1 and comp2 distributions, respectively.
}
\item{log, log.p}{
logical; if TRUE, probabilities p are given as log(p).
}
\item{lower.tail}{
logical; if TRUE (default), probabilities are \eqn{P[X\leq x]}, otherwise \eqn{P[X>x]}. 
}
}
\details{
The compound distribution has cumulative distribution function
\deqn{
F(x;\gamma,\beta,\theta_1,\theta_2)=G_2(G_1(F(x;\gamma,\beta),\theta_1),\theta_2),
}
where \eqn{F} is related to dist, \eqn{G_1} is related to comp1 and \eqn{G_2} is related to comp2.
The support for \eqn{x} depends on the baseline distribution. For exp, gamma, lnorm, paretoII, bisa and lomax, the support 
is \eqn{(0,\infty)}; for beta and kumar is \eqn{(0,1)}; for norm, logis, cauchy and gumbel is \eqn{(-\infty,\infty)}.
The parameter space for \eqn{\gamma} and \eqn{\beta} also depend on the baseline distribution. For exp, \eqn{\gamma>0}; for gamma, paretoII, bisa, lomax,
beta and kumar \eqn{\gamma,\beta >0}; for lnorm, norm, logis, cauchy and gumbel \eqn{\gamma \in \mathbb{R}, \beta>0}.
The parameter space for \eqn{\theta_1} and \eqn{\theta_2} depend on comp1 and comp2. For EXP, EXP2, MO and MO2 options
the corresponding parameter space is \eqn{(0,\infty)}, whereas for SB option is \eqn{(-1,1)}. The probability density function for
each of the baseline distribution is given below.
exp
\deqn{f(x)=\gamma e^{-\gamma x}}
gamma
\deqn{f(x)=\frac{\beta^\gamma}{\Gamma(\gamma)}x^{\gamma-1} e^{-\beta x}}
lnorm
\deqn{f(x)=\frac{1}{x\sqrt{2\pi \beta^2}}\exp\left(-\frac{(\log(x)-\gamma)^2}{\beta^2}\right)}
paretoII
\deqn{f(x)=\frac{\gamma}{\beta}\left(1+\frac{x}{\beta}\right)^{-(\gamma+1)}}
bisa
\deqn{f(x)=\frac{1}{2\sqrt{2\pi}\gamma\beta}\left[\left(\frac{\beta}{x}\right)^{1/2}+\left(\frac{\beta}{x}\right)^{3/2}\right]\exp\left[-\frac{1}{2\gamma^2}\left(\frac{x}{\beta}+\frac{\beta}{x}-2\right)\right]}
beta
\deqn{f(x)=\frac{1}{B(\gamma,\beta)}x^{\gamma-1}(1-x)^{\beta-1}}
kumar
\deqn{f(x)=\gamma \beta x^{\gamma-1}(1-x^\gamma)^{\beta-1}}
For norm, logis, cauchy and gumbel, the probability density function is given by
\deqn{f(x)=\frac{1}{\beta} g\left(\frac{x-\gamma}{\beta}\right)}
where \eqn{g} is given by
norm
\deqn{g(x)=\frac{1}{\sqrt{2\pi}}e^{-x^2/2}}
logis
\deqn{g(x)=\frac{e^{x}}{(1+e^x)^2}}
cauchy
\deqn{g(x)=\frac{1}{\pi (1+x^2)}}
gumbel
\deqn{g(x)=\exp\left(-(x+e^{-x})\right)}
}
\value{
dcompound gives the density, pcompound gives the distribution function, qcompound gives the quantile function, and rcompound generates random deviates.
The length of the result is determined by n for rcompound, and is the maximum of the lengths of the numerical arguments for the other functions.
The numerical arguments other than n are recycled to the length of the result. Only the first elements of the logical arguments are used.
}
%\references{
%% ~put references to the literature/web site here ~
%}
\author{
Yolanda M. Gomez, Diego I. Gallardo, Hector W. Gomez and Barry Arnold
}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

%\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
%}
\examples{
set.seed(2100)
y=rcompound(100, 1.2, 1.4, 1, 0.8, dist="exp", comp1="EXP", comp2="MO")
}

