% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_grid.R
\name{recode_grid}
\alias{recode_grid}
\title{Recodifica id de grillas asignados a  provincias o departamentos de Argentina
(\emph{Recode Argentina's districs id in grids})}
\usage{
recode_grid(data, type = NULL)
}
\arguments{
\item{data}{data.frame obtenido con \code{\link{get_grid}}. Las grillas disponibles
se pueden chequear con \code{\link{show_arg_codes}}.}

\item{type}{la variante del código que se quiere definir para la grilla. Las opciones son \code{'indra'}, \code{'indec'} o \code{'iso'}.}
}
\value{
Los valores por defecto en \code{\link{get_grid}} son \code{codprov} para provincia y \code{coddepto} para departamentos, respectivamente.
Estos corresponden a la codificación de los escrutinios provisorios de elecciones nacionales y se etiquetaron como \code{'indra'} .
Se puede optar por la nomenclatura de \code{'indec'}, con la familia \code{\*_censo}, para ambos niveles, o la de \code{'iso'} con \code{\*_iso} ,
para el nivel provincial.
}
\description{
Función que permite re codificar etiquetas para utilización de grillas de Argentina y de departamentos para los 24 distritos
sub nacionales. Ello permite hacer mas sencilla la vinculación con bases de datos de diversas fuentes.
}
\details{
Respecto el origen de los datos se puede consultar la documentación de
\href{https://www.iso.org/obp/ui/#iso:code:3166:AR}{\code{ISO 3166-2} - International Organization for Standardization} y
del \href{https://www.iso.org/obp/ui/#iso:code:3166:AR}{\emph{INDEC}}.

\code{codprov} y \code{coddepto} son las codificaciones de las bases de datos de \emph{INDRA}, empresa encargada por
muchos años de la tarea del escrutinio provisorio y utilizados en \href{https://electorarg.github.io/polAr/}{polAr}.
}
\examples{

get_grid("ARGENTINA")


get_grid("ARGENTINA") \%>\%
   recode_grid(type = "iso")


}
