% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodimension.R
\name{set_level_data}
\alias{set_level_data}
\alias{set_level_data.geodimension}
\title{Set level data}
\usage{
set_level_data(gd, level_name, data)

\method{set_level_data}{geodimension}(gd, level_name = NULL, data = NULL)
}
\arguments{
\item{gd}{A \code{geodimension} object.}

\item{level_name}{A string.}

\item{data}{A \code{tibble} object.}
}
\value{
A \code{geodimension} object.
}
\description{
Set the data table of a given level.
}
\details{
We can get the table, filter or transform the data and redefine the level table.

It is checked that the attributes that have been used in the relationships
remain in the table.
}
\examples{

ld <- gd_us |>
  get_level_data(level_name = "county",
                 inherited = TRUE)

gd_us <- gd_us |>
  set_level_data(level_name = "county",
                 data = ld)

}
\seealso{
\code{\link{geolevel}}, \code{\link{get_level_data}}

Other geodimension definition functions: 
\code{\link{add_level}()},
\code{\link{geodimension}()},
\code{\link{transform_crs}()}
}
\concept{geodimension definition functions}
