% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoheatmap.R
\name{geoheatmap}
\alias{geoheatmap}
\title{Create a new ggplot-based geographical heatmap for a user-specified geographical grid}
\usage{
geoheatmap(
  facet_data = NULL,
  grid_data = NULL,
  facet_col = NULL,
  value_col = NULL,
  merge_col = NULL,
  dark_label = "black",
  light_label = "white",
  na_label = "white",
  font_size = 3,
  facet_border_col = "white",
  facet_border_size = 2,
  round = FALSE,
  radius = grid::unit(6, "pt"),
  ggplot2_scale_function = ggplot2::scale_fill_continuous,
  hover = FALSE,
  ...
)
}
\arguments{
\item{facet_data}{data frame of facets (geographical locations) and values to plot}

\item{grid_data}{data frame of matching geographical grid positions}

\item{facet_col}{column name in \code{facet_data} that holds the facets. No duplicates;
can be full names (e.g. "\code{Netherlands}") or abbreviations (e.g. "\code{NL}")}

\item{value_col}{column name in \code{facet_data} that holds the values to be plotted}

\item{merge_col}{grids can sometimes hold both native and anglophone language geographical names
(e.g. "\code{Bayern/Bavaria}". If native option is preferable, use \code{merge_col};
defaults to "\code{name}".}

\item{dark_label, light_label, na_label}{dark/light/NA label colors. The specified color will be used
when the algorithm determines labels should be inverted.}

\item{font_size}{font size (default = \code{3})}

\item{facet_border_col}{default "\code{white}" - this creates the "spaces" between boxes}

\item{facet_border_size}{border size}

\item{round}{rounded corners (default: \code{FALSE})}

\item{radius}{if \code{round} is \code{TRUE} then use \code{grid::unit} to specify the corner radius.
Default is \code{grid::unit(6, "pt")} if using rounded corners.}

\item{ggplot2_scale_function}{ggplot2 scale function to use. Defaults to \code{scale_fill_continuous}}

\item{hover}{if \code{hover} is \code{TRUE}, enables interactive plotly plot (see also \code{\link[plotly]{ggplotly}}).
Note it only works when \code{round} is set to \code{FALSE}.}

\item{...}{additional parameters to the scale function}
}
\value{
ggplot2 object
}
\description{
Pass in desired data frame and grid and get back a square choropleth. The function takes
inspiration from the \code{statebins} function, modifying it to allow for non-US grids and territories,
e.g. as defined in the \code{geofacet} package.
The output is a ggplot2 object to which additional layers can be added.
}
\details{
Like in the statebins package, we offer the option to specify a \code{dark_label} color
and a \code{light_label} color. Depending on the selected colour scale function,
\code{geoheatmap} will use that information to determine what label to use on lighter/darker tiles.
This should in principle mean that labels never fade into the background.
Note that this only applies if colours are defined within function,
i.e. not called after the object has already been created.

You can customize the scale function you pass in by using name parameters. All named
parameters not used by \code{geoheatmap()} itself get passed to the scale function.

The default theme is set to \code{theme_void()}, but this can be either overwritten,
or added onto depending on intended plot purposes.
}
\examples{
data(internet)
library(geofacet)
library(ggplot2)

internet_2015 <- subset(internet, year == 2015)
geoheatmap(facet_data= internet_2015, grid_data= europe_countries_grid1,
                    facet_col = "country", value_col = "users")
}
\references{
Bob Rudis. (2022). statebins: Create United States Uniform Cartogram Heatmaps. R package version 1.4.0.
URL: \url{https://CRAN.R-project.org/package=statebins}

Ryan Hafen. (2018). geofacet: 'ggplot2' Faceting Utilities for Geographical Data.
R package version 0.2.1. URL: \url{https://CRAN.R-project.org/package=geofacet}
}
\seealso{
\code{\link[statebins]{statebins}} \code{\link[geofacet]{geofacet}}
}
