% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_weather_radars.R
\name{get_weather_radars}
\alias{get_weather_radars}
\title{Get weather radar metadata}
\usage{
get_weather_radars(source = c("opera", "nexrad"), use_cache = TRUE, ...)
}
\arguments{
\item{source}{Source of the metadata. \code{"opera"}, \code{"nexrad"} or \code{"all"}.
If not provided, \code{"opera"} is used.}

\item{use_cache}{Logical indicating whether to use the cache. Default is
\code{TRUE}. If \code{FALSE} the cache is ignored and the file is fetched anew.
This can also be useful if you want to force a refresh of the cache.}

\item{...}{Additional arguments passed on to reading functions per source,
currently not used.}
}
\value{
A sf or tibble with weather radar metadata. In all cases the column \code{source} is
added to indicate the source of the data and \code{radar} to show the radar identifiers
used in other functions like \code{\link[=get_pvol]{get_pvol()}} and \code{\link[=get_vpts]{get_vpts()}}.
}
\description{
Gets weather radar metadata from \href{https://www.eumetnet.eu/wp-content/themes/aeron-child/observations-programme/current-activities/opera/database/OPERA_Database/index.html}{OPERA}
and/or \href{https://www.ncei.noaa.gov/products/radar/next-generation-weather-radar}{NEXRAD}.
}
\details{
The source files for this function are:
\itemize{
\item For \code{opera}: \href{http://www.eumetnet.eu/wp-content/themes/aeron-child/observations-programme/current-activities/opera/database/OPERA_Database/OPERA_RADARS_DB.json}{OPERA_RADARS_DB.json} (main/current)
and \href{http://www.eumetnet.eu/wp-content/themes/aeron-child/observations-programme/current-activities/opera/database/OPERA_Database/OPERA_RADARS_ARH_DB.json}{OPERA_RADARS_ARH_DB.json} (archive).
A column \code{origin} is added to indicate which file the metadata were derived
from.
\item For \code{nexrad}: \href{https://www.ncei.noaa.gov/access/homr/file/nexrad-stations.txt}{nexrad-stations.txt}.
}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get radar metadata from OPERA
get_weather_radars(source = "opera")

# Get radar metadata from NEXRAD
get_weather_radars(source = "nexrad")
\dontshow{\}) # examplesIf}
}
