# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' This function counts the number of neighboring/touching pixels in a 2D binary image
#'
#' @name count_neighbors
#' @param im A boolean matrix representing a binary image
#' @param diagonal Whether to count diagonal elements as valid neighbors
#' @return A matrix of the same size as \code{im} containing the number of neighboring pixels
#'
#' @details This is an internal function used by geom_outline to clean up outlines
#' @author Michael Hallquist
NULL

count_neighbors <- function(im, diagonal = TRUE) {
    .Call(`_ggbrain_count_neighbors`, im, diagonal)
}

#' Convert a 3-column data.frame (dim1, dim2, value) to a 2-D matrix
#' 
#' @name df2mat
#'
#' @param df   A \code{data.frame} representing a melted 2-D matrix, having columns dim1, dim2, and value
#' @param replace_na if not \code{NULL}, this numeric value will be used to replace any NAs in \code{df} in the
#'   resulting matrix. This is useful if downstream code is not built to handle missing values.
#' @details
#' There is virtually no input validation of \code{df}. You must pass a data.frame that has dim1, dim2, and value as
#'   columns. Otherwise, it will not work as expected.
#'
#' This is a much faster version of the acast function from \code{reshape2} that works only on 2-D matrix conversions.
#' @return The matrix form of the keyed data.frame object
#' @keywords internal
NULL

df2mat <- function(df, replace_na = NULL) {
    .Call(`_ggbrain_df2mat`, df, replace_na)
}

#' This function finds holes by flood filling TRUE into a 2D binary image, starting from the edge
#'
#' @name fill_from_edge
#' @param im A boolean matrix representing a binary image
#' @param nedges An integer specifying how many starting points along the edge to use for
#'   filling TRUE. The starts are northwest (1), southwest (2), southeast (3), and northeast (4).
#'   The compute time increases with the number of starts.
#' @return A matrix of the same size as \code{im} containing the number of neighboring pixels
#'
#' @details This is an internal function used by geom_outline to clean up outlines
#' @author Michael Hallquist
NULL

fill_from_edge <- function(im, nedges = 2L) {
    .Call(`_ggbrain_fill_from_edge`, im, nedges)
}

#' This function finds 'threads' hanging off of the edges of blobs in an image, allowing the user to trim them
#'
#' @name find_threads
#' @param im A numeric matrix representing an image, with non-zero values representing pixels to display
#' @param min_neighbors the minimum number of neighbors a pixel must have to be retained
#' @param maxit the maximum number of iterations to run the thread trimming algorithm. Default: 15.
#' @param diagonal Whether to count diagonal elements as valid neighbors
#' @return A logical matrix matrix of the same size as \code{im} containing the number of neighboring pixels
#'
#' @details This algorithm runs count_neighbors iteratively until no pixel exceeds the trimming threshold \code{min_neighbors}
#'   or the maximum number of iterations, \code{maxit}, is reached.
#'
#'   By running iteratively, long tails are trimmed sequentially by pruning the most disconnected voxels.
#' @author Michael Hallquist
NULL

find_threads <- function(img, min_neighbors = 2L, maxit = 15L, diagonal = FALSE) {
    .Call(`_ggbrain_find_threads`, img, min_neighbors, maxit, diagonal)
}

#' This function flood fills a binary image with TRUE for any value of FALSE
#'
#' @name flood_fill
#' @param im A boolean matrix reference representing a binary image
#' @param x the starting x position for fill
#' @param y the starting y position for fill
#' @param r the number of rows in im
#' @param c the number of columns in im
#' @return Nothing. The matrix \code{im} is modified in place (by reference)
#'
#' @details This is an internal function used by geom_outline to clean up outlines
#' @author Michael Hallquist
NULL

flood_fill <- function(im, x, y, r, c) {
    invisible(.Call(`_ggbrain_flood_fill`, im, x, y, r, c))
}

#' Finds the mode of an integer vector
#' @name integer_mode
#' @param v a vector of integers
#' @param demote_zeros if TRUE, zero will not be allowed to be the mode
#' 
#' @return An integer representing the mode of the vector. If multiple modes are found, then the lowest-valued mode
#'   is returned
#' @keywords internal
NULL

integer_mode <- function(v, demote_zeros) {
    .Call(`_ggbrain_integer_mode`, v, demote_zeros)
}

#' Fast conversion of 2D mat to 3-column data.frame with dim1, dim2, value
#'
#' @name mat2df
#' @description Converts a 2D numeric matrix into a 3-column data.frame
#' @details This function is a faster version of reshape2::melt for the simple 2-D case. It is about 2.5x faster than melt.
#' @param mat A \code{matrix} to convert to data.frame
#' @return A 3-column data.frame with dim1, dim2, and value
#' @keywords internal
#' @author Michael Hallquist
NULL

mat2df <- function(mat, na_zeros = FALSE) {
    .Call(`_ggbrain_mat2df`, mat, na_zeros)
}

#' Finds the nearest non-missing neighbors of a target point in a 2D matrix
#' @name nearest_pts
#'
#' @param x x-position of the point whose neighbors should be found within \code{in_mat}
#' @param y y-position of the point whose neighbors should be found within \code{in_mat}
#' @param in_mat a 2D matrix to search for neighbors of \code{pt}
#' @param neighbors the number of closest non-NA neighboring values to return within \code{in_mat}
#' @param radius the radius around \code{pt} to search. Default: 8.
#' @param ignore_zeros if TRUE, then zero is not a valid imputation value (since these are not data in NIfTIs)
#'
#' @return A vector of \code{neighbors} closest neighboring values around \code{pt}
#' @keywords internal
NULL

nearest_pts <- function(x, y, in_mat, neighbors = 4L, radius = 8L, ignore_zeros = TRUE) {
    .Call(`_ggbrain_nearest_pts`, x, y, in_mat, neighbors, radius, ignore_zeros)
}

#' Imputes missing values in a 2D matrix based on the nearest non-missing neighbors in a given radius
#' @name nn_impute
#' 
#' @param in_mat a 2D matrix to fill using nearest neighbors
#' @param neighbors the number of closest non-NA neighboring values to return within \code{in_mat}. Default is 4.
#' @param radius the radius (in pixels) around each missing value to search for non-missing neighbors. Default is 8.
#' @param aggfun the function used to aggregate the neighbors in imputation. Supports "mean", "median", and "mode."
#' @param ignore_zeros if TRUE, then zero is not a valid imputation value (since these are not data in NIfTIs)
#' 
#' @details The "mode" aggfun should only be used when the matrix \code{in_mat} can be converted to integers without loss
#'   of information (i.e., the data are integerish values already).
#' @return A copy of the matrix with NA values imputed by their nearest neighbors
#' @export
NULL

nn_impute <- function(in_mat, neighbors = 4L, radius = 8L, aggfun = "mean", ignore_zeros = TRUE) {
    .Call(`_ggbrain_nn_impute`, in_mat, neighbors, radius, aggfun, ignore_zeros)
}

#' Sort Matrix by Column
#' 
#' @name sort_mat
#' @description Sorts a given matrix by a specific column while retain the elements in each row.
#'
#' @param x   A \code{matrix} to sort
#' @param col A \code{int} that indicates the column the matrix should sort by.
#' @details
#' This functions sorts a matrix based on one column, keeping the rows together.
#' Note that \code{col} should be a zero-based index of \code{x} (i.e., first column is 0).
#' @return The matrix sorted by values in the specified column.
#' @keywords internal
NULL

sort_mat <- function(x, col) {
    .Call(`_ggbrain_sort_mat`, x, col)
}

