% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depth-median.r
\name{depth_median}
\alias{depth_median}
\title{Depth median}
\usage{
depth_median(x, notion = "zonoid", ...)
}
\arguments{
\item{x}{Matrix of data whose depth median is to be calculated; see
\code{\link[ddalpha:depth.]{ddalpha::depth.()}}.}

\item{notion}{
The name of the depth notion (shall also work with a user-defined depth function named \code{"depth.<name>"}).
}

\item{...}{
Additional parameters passed to the depth functions.
}
}
\value{
A one-row matrix of depth median coordinates.
}
\description{
Compute the depth median of a data set.
}
\details{
This function is called internally by \code{\link[=stat_bagplot]{stat_bagplot()}} and can be
passed to \code{\link[=stat_center]{stat_center()}} but is also exported directly for data analysis.
}
\examples{
# sample median
iris \%>\% 
  subset(select = -Species) \%>\% 
  depth_median()
# groupwise medians
iris \%>\% 
  split(~ Species) \%>\% 
  lapply(subset, select = -Species) \%>\% 
  lapply(depth_median) \%>\% 
  simplify2array() \%>\% t() \%>\% as.data.frame()
}
