% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggproptest.R
\name{ggproptest}
\alias{ggproptest}
\title{Plot test of Equal or Given Proportions}
\usage{
ggproptest(t, alpha=0.05,colaccept="lightsteelblue1", 
colreject="gray84", colstat="navyblue")
}
\arguments{
\item{t}{a list result of \code{\link{prop.test}} of "htest" class}

\item{alpha}{alpha level for ploting distribution, when prop.test is used on more than 2 samples}

\item{colaccept}{color the acceptance area of the test}

\item{colreject}{color for the rejection area of the test}

\item{colstat}{color for the test statistic vline}
}
\description{
Visualise \code{\link{prop.test}} for testing the null that the proportions (probabilities of success) 
in several groups are the same, or that they equal certain given values.
}
\examples{

x  <- c(5, 8, 12)
y <- c(8, 9, 13)
pr_test <- prop.test(x, y)
pr_test
ggproptest(pr_test)

}
