% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_sf_text_inset.R,
%   R/stat_sf_coordinates_inset.R
\docType{data}
\name{geom_sf_text_inset}
\alias{geom_sf_text_inset}
\alias{geom_sf_label_inset}
\alias{stat_sf_coordinates_inset}
\alias{StatSfCoordinatesInset}
\title{Extract coordinates from 'sf' objects (inset-aware)}
\usage{
geom_sf_text_inset(
  mapping = aes(),
  data = NULL,
  stat = "sf_coordinates_inset",
  position = "identity",
  ...,
  where = "inset",
  parse = FALSE,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  fun.geometry = NULL
)

geom_sf_label_inset(
  mapping = aes(),
  data = NULL,
  stat = "sf_coordinates_inset",
  position = "identity",
  ...,
  where = "inset",
  parse = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  fun.geometry = NULL
)

stat_sf_coordinates_inset(
  mapping = ggplot2::aes(),
  data = NULL,
  geom = "point",
  position = "identity",
  ...,
  inset = NA,
  fun.geometry = NULL,
  where = "inset",
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping, data, geom, position, na.rm, show.legend, inherit.aes, fun.geometry, ...}{See \code{\link[ggplot2:stat_sf_coordinates]{ggplot2::stat_sf_coordinates()}}.}

\item{stat, parse, check_overlap}{See \code{\link[ggplot2:ggsf]{ggplot2::geom_sf_text()}}.}

\item{where}{Specifies how the text position interacts with the inset.
\code{"inset"} means that any points in the inset area are drawn on the inset map,
\code{"base"} puts them on the base map. This setting is merely a shorthand for
setting the position aesthetics to \code{after_stat(x_inset)} or \code{after_stat(x)}
respectively, so will have no effect if these are specified in the mapping.}

\item{inset}{Inset configuration; see \code{\link[=configure_inset]{configure_inset()}}.
If \code{NA} (the default), this is inherited from the coord (see \code{\link[=coord_sf_inset]{coord_sf_inset()}}).}
}
\value{
A plot layer
}
\description{
Reduce spatial data to coordinates in the same way as \code{\link[ggplot2:stat_sf_coordinates]{stat_sf_coordinates()}}.
The result can then be used by \code{\link[ggplot2:ggsf]{geom_sf()}} or
\code{\link[=geom_sf_inset]{geom_sf_inset()}} or any geom that needs \code{x} and
\code{y} aesthetics. As this is particularly useful for text, wrappers are
provided for \code{\link[ggplot2:geom_text]{geom_text()}} and \code{\link[ggplot2:geom_text]{geom_label()}}.
}
\section{Required aesthetics}{

\describe{
\item{geometry}{The sf geometry column containing spatial features}
}
}

\section{Computed variables}{

\describe{
\item{x}{X dimension of the simple feature}
\item{y}{Y dimension of the simple feature}
\item{x_inset}{X dimension of the simple feature after inset transformation}
\item{y_inset}{Y dimension of the simple feature after inset transformation}
\item{inside_inset}{logical indicating points inside the inset viewport}
\item{inset_scale}{1 for points outside the inset, otherwise the configured inset scale parameter}
}
}

\examples{
library(ggplot2)

nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)

ggplot(nc) +
  geom_sf_inset() +
  geom_inset_frame() +
  geom_sf_text(
    aes(x = after_stat(x_inset), y = after_stat(y_inset), label = NAME),
    stat = "sf_coordinates_inset") +
  coord_sf_inset(configure_inset(
    shape_circle(
      centre = sf::st_sfc(sf::st_point(c(-80, 35.5)), crs = 4326),
      radius = 50
    ),
    scale = 1.5, translation = c(-50, -140), units = "mi"
  ))
}
\keyword{datasets}
