% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quants.R
\name{quantize_iq2_xxs}
\alias{quantize_iq2_xxs}
\alias{quantize_iq2_xs}
\alias{quantize_iq2_s}
\alias{quantize_iq3_xxs}
\alias{quantize_iq3_s}
\alias{quantize_iq1_s}
\alias{quantize_iq1_m}
\alias{quantize_iq4_nl}
\alias{quantize_iq4_xs}
\title{Quantize Data (IQ)}
\usage{
quantize_iq2_xxs(src_data, n_rows, n_per_row, imatrix = NULL)

quantize_iq2_xs(src_data, n_rows, n_per_row, imatrix = NULL)

quantize_iq2_s(src_data, n_rows, n_per_row, imatrix = NULL)

quantize_iq3_xxs(src_data, n_rows, n_per_row, imatrix = NULL)

quantize_iq3_s(src_data, n_rows, n_per_row, imatrix = NULL)

quantize_iq1_s(src_data, n_rows, n_per_row, imatrix = NULL)

quantize_iq1_m(src_data, n_rows, n_per_row, imatrix = NULL)

quantize_iq4_nl(src_data, n_rows, n_per_row, imatrix = NULL)

quantize_iq4_xs(src_data, n_rows, n_per_row, imatrix = NULL)
}
\arguments{
\item{src_data}{Numeric vector of float values to quantize}

\item{n_rows}{Number of rows}

\item{n_per_row}{Number of elements per row}

\item{imatrix}{Optional importance matrix (numeric vector or NULL)}
}
\value{
Raw vector of quantized data
}
\description{
Quantizes float data to IQ format. IQ formats require importance matrix
initialization before use (see iq2xs_init_impl, iq3xs_init_impl).
}
\seealso{
Other quantization: 
\code{\link{dequantize_row_iq2_xxs}()},
\code{\link{dequantize_row_mxfp4}()},
\code{\link{dequantize_row_q2_K}()},
\code{\link{dequantize_row_q4_0}()},
\code{\link{dequantize_row_tq1_0}()},
\code{\link{ggml_quant_block_info}()},
\code{\link{iq2xs_free_impl}()},
\code{\link{iq2xs_init_impl}()},
\code{\link{iq3xs_free_impl}()},
\code{\link{iq3xs_init_impl}()},
\code{\link{quantize_mxfp4}()},
\code{\link{quantize_q2_K}()},
\code{\link{quantize_q4_0}()},
\code{\link{quantize_row_iq3_xxs_ref}()},
\code{\link{quantize_row_mxfp4_ref}()},
\code{\link{quantize_row_q2_K_ref}()},
\code{\link{quantize_row_q4_0_ref}()},
\code{\link{quantize_row_tq1_0_ref}()},
\code{\link{quantize_tq1_0}()}
}
\concept{quantization}
