% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_discrete_reverse.R
\name{scale_y_discrete_reverse}
\alias{scale_y_discrete_reverse}
\alias{scale_x_discrete_reverse}
\title{Reversed discrete scale for 'ggplot2'}
\usage{
scale_y_discrete_reverse(
  name = waiver(),
  limits = NULL,
  ...,
  expand = waiver(),
  position = "left"
)

scale_x_discrete_reverse(
  name = waiver(),
  limits = NULL,
  ...,
  expand = waiver(),
  position = "bottom"
)
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{limits}{Can be either NULL which uses the default reversed scale values
or a character vector which will be reversed.}

\item{...}{Arguments passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}}

\item{expand}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[ggplot2:expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}

\item{position}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}
}
\value{
A \code{ggplot2} scale object that can be added to a plot.
}
\description{
\code{scale_y_discrete_reverse()} and \code{scale_x_discrete_reverse()} are standard discrete 'ggplot2'
scales with a reversed order of values. Since the ggplot2 coordinate system starts with 0 in
the lower left corner, factors on the y-axis are sorted is descending order by default
(i.e. alphabetically from Z to A). With this scale the the y-axis will start with the
first factor level at the top or with alphabetically correctly ordered values
}
\examples{
library(ggplot2)

# Create sample data
df <- data.frame(
  category = factor(c("A", "B", "C", "D")),
  value = c(10, 5, 8, 3)
)

# Basic plot with reversed y-axis
ggplot(df, aes(x = value, y = category)) +
  geom_col() +
  scale_y_discrete_reverse()

}
\seealso{
\code{\link[=geom_epigantt]{geom_epigantt()}}, \code{\link[ggplot2:scale_discrete]{ggplot2::scale_y_discrete()}}
}
