% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSexp3P.R
\name{SSexp3P}
\alias{SSexp3P}
\title{Self-Starting Nls 'exp3P' Regression Model}
\usage{
SSexp3P(predictor, a, b, c)
}
\arguments{
\item{predictor}{a numeric vector of values at which to evaluate the model.}

\item{a, b, c}{Three numeric parameters responding to the exp3P model.}
}
\value{
No return value (called for side effects).
}
\description{
This selfStart model evaluates the exponential regression function (formula as: y=a*exp(b*x)+c). It has an initial attribute that will evaluate initial estimates of the parameters a, b, and c for a given set of data.
}
\examples{
library(ggtrendline)
x<-1:5
y<-c(2,4,8,16,28)
xy<-data.frame(x,y)
getInitial(y ~ SSexp3P(x,a,b,c), data = xy)
## Initial values are in fact the converged values

fitexp3P <- nls(y~SSexp3P(x,a,b,c), data=xy)
summary(fitexp3P)

prediction <- predFit(fitexp3P , data.frame(x=x), se.fit = TRUE,
                          level = 0.95, interval = "confidence")
yfitexp3P <- prediction$fit
yfitexp3P  # output a matrix of predictions and bounds with column names fit, lwr, and upr.

}
\seealso{
\code{\link{ggtrendline}}, \code{\link{SSexp3P}}, \code{\link{SSpower3P}}, \code{\link[stats]{nls}}, \code{\link[stats]{selfStart}}
}
