% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/givitiCalibrationMain.R
\name{plot.givitiCalibrationBelt}
\alias{plot.givitiCalibrationBelt}
\title{Calibration Belt Plot}
\usage{
\method{plot}{givitiCalibrationBelt}(x, xlim = c(0, 1), ylim = c(0, 1),
  colBis = "red", xlab = "e", ylab = "o",
  main = "GiViTI Calibration Belt", polynomialString = T,
  pvalueString = T, nString = T, table = T, tableStrings = NULL,
  unableToFitString = NULL, ...)
}
\arguments{
\item{x}{A \code{givitiCalibrationBelt} object, to be generated with
the function \code{givitiCalibrationBelt}.}

\item{xlim,ylim}{Numeric vectors of length 2, giving the
x and y coordinates ranges. Default values are \code{c(0,1)}.}

\item{colBis}{The color to be used for the bisector. The default
value is red.}

\item{xlab,ylab}{Titles for the x and y axis. Default values are "e" and
"o", repectively.}

\item{main}{The main title of the plot. The default value is "GiViTI Calibration Belt".}

\item{polynomialString}{If the value is FALSE, the degree of the polynomial is
not printed on the graphical area. If the value is TRUE, the degree m is reported.
If a string is passed to this argument, the string is reported instead of the
text "Polynomial degree". The default value is TRUE.}

\item{pvalueString}{If the value is FALSE, the p-value of the test is
not printed on the graphical area. If the value is TRUE, the p-value is reported.
If a string is passed to this argument, the string is reported instead of the
text "p-value". The default value is TRUE.}

\item{nString}{If the value is FALSE, the sample size is
not printed on the graphical area. If the value is TRUE, the sample size is reported.
If a string is passed to this argument, the string is reported instead of the
text "n". The default value is TRUE.}

\item{table}{A boolean value indicating whether the table reporting the
intersections of the calibration belt with the bisector should be
printed on the plot.}

\item{tableStrings}{Optional. A list with four character elements named
\code{overBisString},\code{underBisString},\code{confLevelString},
\code{neverString}. The four strings of the list are printed instead of the
texts "Over the bisector"/"Under the bisector"/"Confidence level"/"NEVER"
in the table reporting the intersections of the calibration belt with
the bisector.}

\item{unableToFitString}{Optional. If a string is passed to this argument,
this string is reported in the plot area when the dataset is not compatible
with the fit of the calibration belt (e.g. data separation or no positive events).
By default, in such cases the text "Unable to fit the Calibration Belt" is
reported.}

\item{...}{Other graphical parameters passed to the generic \code{plot} method.}
}
\value{
The function generates the calibration belt plot. In addition,
a list containing the following components is returned:
\describe{
  \item{p.value}{The p-value of the test.}
  \item{m}{The degree of the polynomial at the end of the forward selection.}
}
}
\description{
The \code{plot} method for calibration belt objects.
}
\examples{
#Random by-construction well calibrated model
e <- runif(100)
o <- rbinom(100, size = 1, prob = e)
cb <- givitiCalibrationBelt(o, e, "external")
plot(cb)

#Random by-construction poorly calibrated model
e <- runif(100)
o <- rbinom(100, size = 1, prob = logistic(logit(e)+2))
cb <- givitiCalibrationBelt(o, e, "external")
plot(cb)
}
\seealso{
\code{\link{givitiCalibrationBelt}}
 to compute the calibaration belt and
 \code{\link{givitiCalibrationTest}} to perform the
 associated calibration test.
}

