% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov_glmstarma.R
\name{vcov.dglmstarma}
\alias{vcov.dglmstarma}
\alias{sandwich_variance}
\alias{vcov.glmstarma}
\title{Variance-Covariance Matrix for glmstarma and dglmstarma objects}
\usage{
\method{vcov}{dglmstarma}(object, return_value = c("mean", "dispersion", "both"))

\method{vcov}{glmstarma}(object)
}
\arguments{
\item{object}{An object of class \code{glmstarma} or \code{dglmstarma} for which the variance-covariance matrix is to be computed.}

\item{return_value}{A character string specifying which variance-covariance matrix to return. Options are "mean", "dispersion", or "both". Default is "mean".}
}
\value{
For \code{glmstarma} objects, the function returns the variance-covariance matrix of the mean model coefficients.
For \code{dglmstarma} objects, the function return depends on the \code{return_value} argument:
\item{mean}{Variance-covariance matrix for the mean model coefficients.}
\item{dispersion}{Variance-covariance matrix for the dispersion model coefficients.}
\item{both}{A list containing both variance-covariance matrices.}
}
\description{
Computes the variance-covariance matrix for \code{glmstarma} and \code{dglmstarma} objects.
}
\details{
The variance-covariance matrix is computed using a sandwich estimator approach, which accounts for potential misspecification of the model.
The sandwich variance estimation is defined as \eqn{V = G^{-1} H G^{-1}}, where \eqn{G} is the expected information matrix and \eqn{H} is the empirical covariance matrix of the score functions.
In case of \code{dglmstarma} objects, separated variance-covariance matrices are computed for the mean and dispersion models because of the alternating estimation procedure.
}
\examples{
\donttest{
dat <- load_data("chickenpox", directory = tempdir())
chickenpox <- dat$chickenpox
population_hungary <- dat$population_hungary
W_hungary <- dat$W_hungary

model_autoregressive <- list(past_obs = rep(1, 7))
fit <- glmstarma(chickenpox, model_autoregressive, W_hungary, family = vpoisson("log"),
                 covariates = list(population = population_hungary))
vcov(fit)

mean_model <- list(past_obs = rep(1, 7))
dispersion_model <- list(past_obs = 1)
fit2 <- dglmstarma(chickenpox, mean_model, dispersion_model, mean_family = vquasipoisson("log"),
                   dispersion_link = "log",
                   wlist = W_hungary, 
                   mean_covariates = list(population = population_hungary))
vcov(fit2)
vcov(fit2, return_value = "dispersion")
vcov(fit2, return_value = "both")
}
}
\seealso{
\code{\link{vcov}}, \code{\link{glmstarma}}, \code{\link{dglmstarma}}
}
