% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metastmelanoma.R
\docType{data}
\name{metastmelanoma}
\alias{metastmelanoma}
\title{metastmelanoma - metastatic melanoma trial data}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 285 rows and 11 columns.
}
\usage{
metastmelanoma
}
\description{
The dataset data from a cancer clinical trial and the results are published in Kirkwood et al. (1996). In this study following surgery for deep primary or metastatic melanoma, the overall survival and the disease-free effect of Interferon alpha-2b (IFN) was investigated on 285 patients.
Maiti and Pradhan (2009) fitted a logistic regression considering failcens as the response variable, where failcens is 1 if the subject relapses and 0 otherwise. We fit the model including six important predictors size type nodal age sex trt; where size is the size of primary in cm2, which is dichotomized at the median; type is the type of primary containing two levels— superficial spreading and other; nodal is the presence or absence of microscopic nonpalpable and palpable regional lymph node metastasis—1 for node positive and 0 otherwise; age is the age of a subject in years; sex is a variable indicating the gender (male or female); and finally trt is the treatment containing two levels (1 if treated with IFN and 0 otherwise).
}
\examples{
data(metastmelanoma)
f_fit <- emforbeta(failcens ~ size+type+nodal+age+sex+trt,
                   data=metastmelanoma,
                   family=binomial, method="glm.fit")
summary(f_fit$mfit)
vcov_beta<-f_fit$cvcov # variance-covariance calculation using Louis (1982)
vcov_beta
se_beta_em<-sqrt(diag(vcov_beta))
se_beta_em

# Firth Correction
f_fit <- emforbeta(failcens ~ size+type+nodal+age+sex+trt,
                   data=metastmelanoma,
                   family=binomial, method="brglmFit")
summary(f_fit$mfit)
vcov_beta<-f_fit$cvcov # variance-covariance calculation using Louis (1982)
vcov_beta
se_beta_em<-sqrt(diag(vcov_beta))
se_beta_em

}
\references{
Cytel Inc (2010). LogXact 9 User Manual: Discrete Regression Analysis. Cambridge, Massachusetts: Cytel Inc.

Kirkwood, J. M., Strawderman, M. H., Ernstoff, M. S., Smith, T. J., Borden, E. C., and Blum, R. H. (1996). Interferon alfa-2b ad- juvant therapy of high-risk resected cutaneous melanoma: The Eastern Cooperative Oncology Group trial EST 1684. Journal of Clinical Oncology 14, 7–17.

Maiti, T., Pradhan, V. (2009). Bias reduction and a solution of separation of logistic regression with missing covariates. Biometrics, 65, 1262-1269.

Pradhan, V., Nychka, D. and Bandyopadhyay, S. (2025). Beyond the Odds: Fitting Logistic Regression with Missing Data in Small Samples (submitted).
}
\keyword{datasets}
