% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_pseudo_absences.R
\name{generate_pseudo_absences}
\alias{generate_pseudo_absences}
\title{Generate Pseudo-Absence Points Using Different Methods Based on Presence Points, Covariates, and Study Area Polygon}
\usage{
generate_pseudo_absences(
  method = c("random", "target_group", "buffer_out", "env_space_flexsdm"),
  presences,
  raster_stack,
  predictor_variables,
  study_area = NULL,
  target_group_points = NULL,
  coords = c("decimalLongitude", "decimalLatitude"),
  pa_buffer_distance = 0.5,
  ratio = 1,
  attempts = 100,
  seed = NULL
)
}
\arguments{
\item{method}{Character; one of "random", "target_group", "buffer_out", or "env_space_flexsdm".}

\item{presences}{Data frame of presence points with coordinates and timestamp.}

\item{raster_stack}{SpatRaster of covariates.}

\item{predictor_variables}{Character vector of selected predictors.}

\item{study_area}{Optional sf polygon (used for clipping).}

\item{target_group_points}{Optional data frame of sampling points (for target-group).}

\item{coords}{Vector of coordinate column names.}

\item{pa_buffer_distance}{Numeric; buffer radius in degrees around each presence. Default is 0.5.}

\item{ratio}{Ratio of pseudo-absences to presences.}

\item{attempts}{Max attempts to fulfill sample size.}

\item{seed}{Optional seed for reproducibility.}
}
\value{
A data frame of pseudo-absence points (pa = 0) with covariates.
}
\description{
Wrapper function for pseudo-absence generation methods, such as
background random points, target-group, and using buffer area.
}
