% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-accidental.R
\name{Accidental}
\alias{Accidental}
\title{Create \code{Accidental} Object}
\usage{
Accidental(name, i, j = NULL, to = NULL, bracket = NULL)
}
\arguments{
\item{name}{A single character, which represents the name of the
accidental. \code{"flat"} and \code{"sharp"} are two common examples.
For a complete list of accidentals, please refer to
\href{https://w3c.github.io/musicxml/musicxml-reference/data-types/accidental-value/}{the MusicXML specification}.
Unfortunately, not all accidentals are supported in MuseScore.}

\item{i}{A single positive integer, which represents the position
of the accidental in a musical line.}

\item{j}{Optional. A single positive integer, which represents the
position of the accidental in a chord.}

\item{to}{Optional. A single character or a single positive integer,
which indicates the musical line where to add the accidental.}

\item{bracket}{Optional. A single logical, which indicates if the
accidental is enclosed in brackets.}
}
\value{
A list of class \code{Accidental}.
}
\description{
Create an \code{Accidental} object to represent an accidental symbol.
}
\examples{
# Create an `Accidental`
accidental <- Accidental("natural", 2, bracket = TRUE)
accidental

# Add it to a `Music`
music <- Music() + Meter(4, 4) + Line(c("C4", "C4")) + accidental
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding an \code{Accidental} to a \code{Music} object.
}
