% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smem.R
\name{smem}
\alias{smem}
\title{Select the number of mixture components and estimate the parameters of a
Gaussian mixture model}
\usage{
smem(
  gmm,
  data,
  y = NULL,
  score = "bic",
  split = TRUE,
  merge = TRUE,
  min_comp = 1,
  max_comp = Inf,
  space = 0.5,
  max_rank = 1,
  max_iter_smem = 10,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{gmm}{An initial object of class \code{gmm}.}

\item{data}{A data frame or numeric matrix containing the data used in the
SMEM algorithm. Its columns must explicitly be named after the variables of
\code{gmm} and must not contain missing values.}

\item{y}{A character vector containing the dependent variables if a
conditional model is estimated (which involves maximizing a conditional
score). If \code{NULL} (the default), the joint model is estimated.}

\item{score}{A character string (\code{"aic"}, \code{"bic"} or
\code{"loglik"}) corresponding to the scoring function.}

\item{split}{A logical value indicating whether split operations are allowed
(if \code{FALSE}, no mixture component can be split).}

\item{merge}{A logical value indicating whether merge operations are allowed
(if \code{FALSE}, no mixture component can be merged).}

\item{min_comp}{A positive integer corresponding to the minimum number of
mixture components.}

\item{max_comp}{A positive integer corresponding to the maximum number of
mixture components.}

\item{space}{A numeric value in [0, 1[ corresponding to the space between two
subcomponents resulting from a split.}

\item{max_rank}{A positive integer corresponding to the maximum rank for
testing the split and merge candidates.}

\item{max_iter_smem}{A non-negative integer corresponding to the maximum
number of iterations.}

\item{verbose}{A logical value indicating whether iterations in progress
are displayed.}

\item{\dots}{Additional arguments passed to function \code{\link{em}}.}
}
\value{
A list with elements:
\item{gmm}{The final \code{gmm} object.}
\item{posterior}{A numeric matrix containing the posterior probabilities for
each observation.}
\item{seq_score}{A numeric vector containing the sequence of scores measured
initially and after each iteration.}
\item{seq_oper}{A character vector containing the sequence of split and merge
operations performed at each iteration.}
}
\description{
This function selects the number of mixture components and estimates the
parameters of a Gaussian mixture model using a split-and-merge EM (SMEM)
algorithm. At the first iteration, the classic EM algorithm is performed to
update the parameters of the initial model. Then each following iteration
consists in splitting a component into two or merging two components, before
re-estimating the parameters with the EM algorithm. The selected split or
merge operation is the one that maximizes a scoring function (after the
re-estimation process). To avoid testing all possible operations, the split
and merge candidates are initially ranked according to relevant criteria
(Zhang \emph{et al.}, 2003). At first, the top-ranked split and top-ranked
merge operations are tested. If neither of them increases the score, the
second-ranked ones are considered, and so on. The SMEM algorithm stops if a
given maximum rank is reached without improving the score.
}
\examples{
data(data_body)
gmm_1 <- add_var(NULL, c("WAIST", "AGE", "FAT", "HEIGHT", "WEIGHT"))
res_smem <- smem(gmm_1, data_body, max_comp = 3, verbose = TRUE)

}
\references{
Zhang, Z., Chen, C., Sun, J. and Chan, K. L. (2003). EM algorithms for
Gaussian mixtures with split-and-merge operation. \emph{Pattern Recognition},
36(9):1973--1983.
}
\seealso{
\code{\link{em}}, \code{\link{stepwise}}
}
