% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teststatistics.R
\name{CM}
\alias{CM}
\title{The Cramer-von Mises test statistic}
\usage{
CM(data)
}
\arguments{
\item{data}{a vector of positive numbers.}
}
\value{
value of the test statistic.
}
\description{
This function computes value of the test statistic of the goodness-of-fit test for the inverse Gaussian family in the spirit of Cramer and von Mises. Note that this tests the composite hypothesis of fit to the family of inverse Gaussian distributions.
}
\details{
Let \eqn{X_{(j)}} denote the \eqn{j}th order statistic of \eqn{X_1, \ldots, X_n}, a sequence of  independent observations of a positive random variable \eqn{X}. Furthermore, let \eqn{\hat{F}(x) = F(x; \hat{\mu}_n, \hat{\lambda}_n)}, where \eqn{F} is the distribution function of the inverse Gaussian distribution. 
Note that  \eqn{\hat{\mu}_n,\hat{\lambda}_n} are the maximum likelihood estimators for \eqn{\mu} and \eqn{\lambda}, respectively, the parameters of the inverse Gaussian distribution.
The null hypothesis is rejected for large values of the test statistic: 
\deqn{CM = \frac{1}{12n} + \sum_{j=1}^{n} \left( \hat{F}(X_{(j)}) - \frac{2j-1}{2n} \right)^2.}
}
\examples{
CM(rmutil::rinvgauss(20,2,1))

}
\references{
Allison, J.S., Betsch, S., Ebner, B., Visagie, I.J.H. (2022) "On Testing the Adequacy of the Inverse Gaussian Distribution". \href{https://www.mdpi.com/2227-7390/10/3/350}{LINK}
}
