% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teststatistics.R
\name{WA}
\alias{WA}
\title{statistic of the Watson goodness-of-fit test for the gamma family}
\usage{
WA(data, k_estimator)
}
\arguments{
\item{data}{a vector of positive numbers. NOTE: \code{data} has to be the rescaled data, i.e. devided by the estimated \code{scale} parameter!}

\item{k_estimator}{value of the estimated \code{shape} parameter.}
}
\value{
value of the test statistic
}
\description{
This function computes the goodness-of-fit test statistic for the gamma family in the spirit of Watson. Note that this tests the composite hypothesis of fit to the family of gamma distributions, i.e. a bootstrap procedure is implemented to perform the test, see \code{\link{crit.values}}.
}
\details{
The Watson test is computed as described in Henze et. al. (2012). Values of \code{k_estimator} are found by \code{\link{gamma_est}}.
}
\examples{
X=stats::rgamma(20,3,6)
WA(X,k_estimator=gamma_est(X)[1])

}
\references{
Henze, N., Meintanis, S.G., Ebner, B. (2012) "Goodness-of-fit tests for the Gamma distribution based on the empirical Laplace transform". Communications in Statistics - Theory and Methods, 41(9): 1543-1556. \href{https://doi.org/10.1080/03610926.2010.542851}{DOI}
}
