% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gammaTest.R
\name{test.AD}
\alias{test.AD}
\title{The Anderson-Darling goodness-of-fit test for the gamma family}
\usage{
test.AD(data, boot = 500, alpha = 0.05)
}
\arguments{
\item{data}{a vector of positive numbers.}

\item{boot}{number of bootstrap iterations used to obtain critical value.}

\item{alpha}{level of significance of the test.}
}
\value{
a list containing the value of the test statistic, the approximated critical value and a test decision on the significance level \code{alpha}: \cr
\describe{
        \item{\code{$T.value}}{the value of the test statistic.}
        \item{\code{$cv}}{the approximated critical value.}
        \item{\code{$par.est}}{number of points used in approximation.}
        \item{\code{$Decision}}{the comparison of the critical value and the value of the test statistic.}
        \item{\code{$sig.level}}{level of significance chosen.}
        \item{\code{$boot.run}}{number of bootstrap iterations.}
}
}
\description{
This function computes the goodness-of-fit test for the gamma family in the spirit of Anderson and Darling. Note that this tests the composite hypothesis of fit to the family of gamma distributions, i.e. a bootstrap procedure is implemented to perform the test.
}
\details{
The Anderson-Darling  test is computed as described in Henze et. al. (2012). Critical values are obtained by a parametric bootstrap procedure, see \code{\link{crit.values}}.
}
\examples{
test.AD(stats::rgamma(20,3,6),boot=100)

}
\references{
Henze, N., Meintanis, S.G., Ebner, B. (2012) "Goodness-of-fit tests for the Gamma distribution based on the empirical Laplace transform". Communications in Statistics - Theory and Methods, 41(9): 1543-1556. \href{https://doi.org/10.1080/03610926.2010.542851}{DOI}
}
