% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_comp_data.R
\name{sim_comp_data}
\alias{sim_comp_data}
\title{Simulate a complete clinical trial with event data drawn from a
piecewise exponential distribution}
\usage{
sim_comp_data(
  hazard_treatment,
  hazard_control = NULL,
  cutpoints = 0,
  N_total,
  lambda = 0.3,
  lambda_time = 0,
  end_of_study,
  block = 2,
  rand_ratio = c(1, 1),
  prop_loss = 0
)
}
\arguments{
\item{hazard_treatment}{vector. Constant hazard rates under the treatment
arm.}

\item{hazard_control}{vector. Constant hazard rates under the control arm.}

\item{cutpoints}{vector. Times at which the baseline hazard changes. Default
is \code{cutpoints = 0}, which corresponds to a simple (non-piecewise)
exponential model.}

\item{N_total}{integer. Maximum sample size allowable}

\item{lambda}{vector. Enrollment rates across simulated enrollment times. See
\code{\link{enrollment}} for more details.}

\item{lambda_time}{vector. Enrollment time(s) at which the enrollment rates
change. Must be same length as lambda. See \code{\link{enrollment}} for
more details.}

\item{end_of_study}{scalar. Length of the study; i.e. time at which endpoint
will be evaluated.}

\item{block}{scalar. Block size for generating the randomization schedule.}

\item{rand_ratio}{vector. Randomization allocation for the ratio of control
to treatment. Integer values mapping the size of the block. See
\code{\link{randomization}} for more details.}

\item{prop_loss}{scalar. Overall proportion of subjects lost to follow-up.
Defaults to zero.}
}
\value{
A data frame with 1 row per subject and columns:
\describe{
\item{\code{time:}}{
numeric. Time of event or censoring time.
}
\item{\code{treatment:}}{
integer. Treatment arm with values \code{1L} for experimental arm, and
\code{0L} for control arm (only if \code{hazard_control} is given).
}
\item{\code{event:}}{
integer. Indicator of whether event occurred (\code{=1L} if occurred
and \code{=0L} if right-censored).
}
\item{\code{enrollment:}}{
numeric. Time of patient enrollment relative to time trial enrolled
first patient.
}
\item{\code{id:}}{
integer. Identification number for each patient.
}
\item{\code{loss_to_fu:}}{
logical. Indicator of whether the patient was lost to follow-up during
the course of observation.
}
}
}
\description{
Simulate a complete clinical trial with event data drawn from a
piecewise exponential distribution
}
