% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_management.R
\name{ga_filter_update_filter_link}
\alias{ga_filter_update_filter_link}
\title{Update an existing profile filter link. Patch semantics supported}
\usage{
ga_filter_update_filter_link(
  viewFilterLink,
  accountId,
  webPropertyId,
  viewId,
  linkId,
  method = c("PUT", "PATCH")
)
}
\arguments{
\item{viewFilterLink}{The profileFilterLink object}

\item{accountId}{Account Id of the account that contains the filter}

\item{webPropertyId}{Web property Id to which the profile filter link belongs}

\item{viewId}{View Id to which the profile filter link belongs}

\item{linkId}{The id of the profile filter link to be updated}

\item{method}{PUT by default. Supports patch semantics when set to PATCH}
}
\description{
Update an existing profile filter link. Patch semantics supported
}
\examples{

\dontrun{

# create a filter object
Filter <- list(
 name = 'googleAnalyticsR test: Exclude Internal Traffic',
 type = 'EXCLUDE',
 excludeDetails = list(
   field = 'GEO_IP_ADDRESS',
   matchType = 'EQUAL',
   expressionValue = '199.04.123.1',
   caseSensitive = 'False'
   )
 )
 
 # link Filter to a View
 response <- ga_filter_add(Filter, 
                           accountId = 12345, 
                           webPropertyId = "UA-12345-1", 
                           viewId = 654321, 
                           linkFilter = TRUE)
                           
# create Filter patch to move existing filter up to rank 1
viewFilterLink <- list(rank = 1)

# use the linkId given in response$id to update to new rank 1
response2 <- ga_filter_update_filter_link(viewFilterLink, 
                                          accountId = 12345, 
                                          webPropertyId = "UA-12345-1", 
                                          viewId = 654321,  
                                          linkId = response$id)

}

}
\seealso{
\url{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/profileFilterLinks}

Other managementAPI functions: 
\code{\link{ga_experiment}()},
\code{\link{ga_experiment_list}()},
\code{\link{ga_filter_add}()},
\code{\link{ga_filter_apply_to_view}()},
\code{\link{ga_filter_update}()},
\code{\link{ga_segment_list}()}
}
\concept{managementAPI functions}
