% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webprops.R
\name{ga_webproperty}
\alias{ga_webproperty}
\title{Get a web property}
\usage{
ga_webproperty(accountId, webPropertyId)
}
\arguments{
\item{accountId}{Account Id}

\item{webPropertyId}{Web Property Id e.g. \code{UA-12345-1}}
}
\value{
webproperty
}
\description{
Gets metadata for one particular web property
}
\examples{

\dontrun{
library(googleAnalyticsR)
ga_auth()
wp <- ga_webproperty(1058095, "UA-1058095-1")
}
}
\seealso{
Other account structure functions: 
\code{\link{ga_account_list}()},
\code{\link{ga_accounts}()},
\code{\link{ga_view}()},
\code{\link{ga_view_list}()},
\code{\link{ga_webproperty_list}()}
}
\concept{account structure functions}
