% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{transmute_weights}
\alias{transmute_weights}
\alias{nested_transmute}
\alias{nested_transmute2}
\title{Transmute weights}
\usage{
transmute_weights(r, s)

nested_transmute(r1, r2, s, t = c(1, 1))

nested_transmute2(r1, r2, s, t = c(1, 1))
}
\arguments{
\item{r, s}{A finite number giving the order of the generalized mean. See
details.}

\item{r1}{A finite number giving the order of the outer generalized mean.}

\item{r2}{A pair of finite numbers giving the order of the inner generalized
means.}

\item{t}{A pair of strictly positive weights for the inner generalized
means. The default is equal weights.}
}
\value{
\code{transmute_weights()} returns a function:

\preformatted{function(x, w = NULL, tol = .Machine$double.eps^0.5){...}}

\code{nested_transmute()} and \code{nested_transmute2()} similarly return a
function:

\preformatted{function(x, w1 = NULL, w2 = NULL, tol = .Machine$double.eps^0.5){...}}
}
\description{
Transmute weights to turn a generalized mean of order \eqn{r} into a
generalized mean of order \eqn{s}. Useful for calculating additive and
multiplicative decompositions for a generalized-mean index, and those made
of nested generalized means (e.g., Fisher index).
}
\details{
The function \code{transmute_weights(r, s)} returns a function to compute a
vector of weights \code{v(x, w)} such that

\preformatted{generalized_mean(r)(x, w) == generalized_mean(s)(x, v(x, w))}

\code{nested_transmute(r1, r2, t, s)} and \code{nested_transmute2(r1, r2, t, s)} do
the same for nested generalized means, so that

\preformatted{nested_mean(r1, r2, t)(x, w1, w2) ==
  generalized_mean(s)(x, v(x, w1, w2))}

Transmuting weights returns a value that is the same length as \code{x},
so any missing values in \code{x} or the weights will return \code{NA}.
Unless all values are \code{NA}, however, the result will still satisfy
the above identities when \code{na.rm = TRUE}.
}
\examples{
x <- 1:3
w <- 3:1

# Calculate the geometric mean as an arithmetic mean and
# harmonic mean by transmuting the weights.

geometric_mean(x)
arithmetic_mean(x, transmute_weights(0, 1)(x))
harmonic_mean(x, transmute_weights(0, -1)(x))

# Works for nested means, too.

w1 <- 3:1
w2 <- 1:3

fisher_mean(x, w1, w2)

arithmetic_mean(x, nested_transmute(0, c(1, -1), 1)(x, w1, w2))
arithmetic_mean(x, nested_transmute2(0, c(1, -1), 1)(x, w1, w2))
}
\references{
See \code{vignette("decomposing-indexes")} for more details.
}
\seealso{
\code{\link[=generalized_mean]{generalized_mean()}} for the generalized mean and \code{\link[=nested_mean]{nested_mean()}} for the
nested mean.

\code{\link[=extended_mean]{extended_mean()}} for the extended mean that underlies
\code{transmute_weights()}.

\code{\link[=contributions]{contributions()}} for calculating additive percent-change
contributions.

\code{\link[=grouped]{grouped()}} to make these functions operate on grouped data.

Other weights functions: 
\code{\link{factor_weights}()},
\code{\link{scale_weights}()}
}
\concept{weights functions}
