% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6-Schema.R
\name{Schema}
\alias{Schema}
\title{GraphQL Schema object}
\description{
Manages a GraphQL schema definition.  A Schema can add more GraphQL type definitions, assist in determining definition types, retrieve particular definitions, and can combine with other schema definitions.

Typically, Schema class objects are created using \code{\link[=gqlr_schema]{gqlr_schema()}}.  Creating a \code{Schema$new()} object should be reserved for when multiple Schema objects are combined.
}
\section{Usage}{

\preformatted{
## using star_wars_schema from
# example(gqlr_schema)
star_wars_schema$get_schema()
star_wars_schema$is_enum("Episode") # TRUE
star_wars_schema$is_object("Episode") # FALSE
execute_request("{ hero { name } }", star_wars_schema)
}
}

\section{Initialize}{

\describe{
\item{schema}{Either a character GraphQL definition of a schema or another Schema object.  Extending methods and descriptions should be added with \code{gqlr_schema}}.
}

The initialize function will automatically add \itemize{
\item{Scalars: Int, Float, String, Boolean}
\item{Directives: @skip and @include}
\item{Introspection Capabilities}
}
}

\section{Details}{

\verb{$add(obj)}: function to add either another Schema's definitions or Document of definitions.  \code{obj} must inherit class of either \code{'Schema'} or \code{'Document'}

\verb{$is_scalar(name)}, \verb{$is_enum(name)}, \verb{$is_object(name)}, \verb{$is_interface(name)}, \verb{$is_union(name)}, \verb{$is_input_object(name)}, \verb{$is_directive(name)}, \verb{$is_value(name)}: methods to determine if there is a definition of the corresponding definition type for the provided name.

\verb{$get_scalar(name)}, \verb{$get_enum(name)}, \verb{$get_object(name)}, \verb{$get_interface(name)}, \verb{$get_union(name)}, \verb{$get_input_object(name)}, \verb{$get_directive(name)}, \verb{$get_value(name)}: methods to retrieve a definition of the corresponding definition type for the provided name. If the object can't be found, \code{NULL} is returned. When printed, it quickly conveys all known information of the definition.  Due to the nature of R6 objects, definitions may be retrieved and altered after retrieval.  This is helpful for adding descriptions or resolve after the initialization.

\verb{$get_scalars(name)}, \verb{$get_enums(name)}, \verb{$get_objects(name)}, \verb{$get_interfaces(name)}, \verb{$get_unions(name)}, \verb{$get_input_objects(name)}, \verb{$get_directives(name)}, \verb{$get_values(name)}: methods to retrieve all definitions of the corresponding definition type.

\verb{$get_type(name)}: method to retrieve an object of unknown type. If the object can't be found, \code{NULL} is returned. When printed, it quickly conveys all known information of the definition.

\verb{$get_type(name)}: method to retrieve an object of unknown type. If the object can't be found, \code{NULL} is returned.

\verb{$get_schema()}: method to retrieve full definition of schema. When printed, it quickly conveys all types in the schema.

\verb{$get_query_object()}, \verb{$get_mutation_object()}: helper method to retrieve the schema definition query or mutation object.

\verb{$implements_interface()}: helper method to retrieve all objects who implement a particular interface.

\verb{$is_valid}: boolean that determines if a Schema object has been validated.  All Schema objects are validated at the time of request execution.  The Schema will remain valid until new definitions are added.
}

\seealso{
\code{\link[=gqlr_schema]{gqlr_schema()}}
}
