% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt_ppv.R
\name{opt_ppv}
\alias{opt_ppv}
\title{Optimize Probabilistic Path Value}
\usage{
opt_ppv(sociomatrix, source, target, odds_scale = 1,
  odds_scale_by_node = NULL)
}
\arguments{
\item{sociomatrix}{a nonnegative, real valued sociomatrix.}

\item{source}{an integer index corresponding to a node in \code{sociomatrix}}

\item{target}{an integer index corresponding to a node in \code{sociomatrix}}

\item{odds_scale}{a nonnegative real number indicating the observed tie
strength value that corresponds to 1-1 transmission odds}

\item{odds_scale_by_node}{sets a transfer odds scale for each node in a 
probabilistic path value calculation.}
}
\description{
Identify the path of optimal probabilistic path value from a source node
to a target node.
}
\seealso{
\code{\link{ppv}} to calculate the value of a user-specified path,
    \code{\link{all_opt_ppv}} to simultaneously identify the optimal paths 
    from any source node to any target node.
}
